/* auteur: Nicolas Schiper
   date: 30/09/2003 */

package epfl.lsr.SysExpl.couche1TimeSlicing;

import epfl.lsr.SysExpl.couche0.*;
import java.util.LinkedList;

public class NoyauTimeSlicing {

    /** La liste des threads pouvant s'excuter.
        La tte de cette liste reprsente le thread
        actuellement entrain de s'excuter.*/
    protected static LinkedList threadsPrets = new LinkedList();

    /** Cr un thread.
        @param className Le nom de la classe qui implmente ce thread.
                         Remarque: Cette classe doit tendre la classe
                         Coroutine. */
    public static void createThread(String className) throws Exception {
	   try {
          Coroutine co = new Coroutine(className);
          threadsPrets.addLast(co);
	   }
	   catch(CoroutineException ce) {
		   throw new Exception(ce.getMessage());
	   }
	}

    /** Dmarre le systme en passant le contrle au thread en tte de la liste. <br>
        Chaque fois que l'utilisateur appuie sur la touche -RETURN-, le thread qui tait
        entrain de s'excuter est stopp au profit du suivant dans la liste threadsPrets.*/
	public static void demarrerSysteme() throws Exception {

		Coroutine co;

		if (threadsPrets.size() == 0)
		   throw new Exception("Aucun thread  excuter!");

		else {
		   try {
		      for (;;) {
		   	     co = (Coroutine)threadsPrets.getFirst();
		   		 Coroutine.ioTransfer(co, Coroutine.keybIO);
		   		 co = (Coroutine)threadsPrets.removeFirst();
		   		 threadsPrets.addLast(co);
		   	  }
		   }
		   catch (CoroutineException ce) {
		      ce.printStackTrace();
		   	  System.out.println(ce.getMessage());
		   }
	   }
	}
}