/* auteur: Nicolas Schiper
   date: 30/09/2003 */

package epfl.lsr.SysExpl.couche1SemaphoreTimeSlicing;

import epfl.lsr.SysExpl.couche0.*;
import java.util.LinkedList;

public class NoyauSemaphore {

    /** La liste des coroutines pouvant s'excuter.
        La tte de cette liste reprsente la coroutine
        actuellement entrain de s'excuter.*/
	protected static LinkedList threadsPrets = new LinkedList();

    /** Cr un thread.
        @param className Le nom de la classe qui implmente ce thread.
                         Remarque: Cette classe doit tendre la classe
                         Coroutine. */
    public static void createThread(String className) throws Exception {
	   try {
          Coroutine co = new Coroutine(className);
          threadsPrets.addLast(co);
	   }
	   catch(CoroutineException ce) {
		   throw new Exception(ce.getMessage());
	   }
	}

    /** Dmarre le systme. */
    public static void demarrerSysteme() throws Exception {

		Coroutine co;

		if (threadsPrets.size() == 0)
		   throw new Exception("Aucun thread  excuter!");

		else {
		   try {
		      for (;;) {
		   	     co = (Coroutine)threadsPrets.getFirst();
		   		 Coroutine.ioTransfer(co, Coroutine.keybIO);
		   		 co = (Coroutine)threadsPrets.removeFirst();
		   		 threadsPrets.addLast(co);
		   	  }
		   }
		   catch (CoroutineException ce) {
		      ce.printStackTrace();
		   	  System.out.println(ce.getMessage());
		   }
	   }
	}
}

