/* auteur: Nicolas Schiper
   date: 30/09/2003 */

package epfl.lsr.SysExpl.couche1SemaphoreTimeSlicing;

import epfl.lsr.SysExpl.couche0.*;
import java.util.LinkedList;

public class Semaphore {

	private int n;
	private LinkedList enAttente;

	public Semaphore(int n) {
		this.n = n;
		enAttente = new LinkedList();
	}

    /** Excute P sur le smaphore. */
    public void P() throws Exception {

	   Coroutine coRetiree, coDemarree;

	   try {
		   Coroutine.masquerInterruption();

           this.n--;

           /* Est-ce que le smaphore est verrouill ?*/
           if (n<0) {
		       coRetiree = (Coroutine) NoyauSemaphoreTimeSlicing.threadsPrets.removeFirst();
		       enAttente.addLast(coRetiree);

		       if(NoyauSemaphoreTimeSlicing.threadsPrets.size() == 0)
		    	   throw new Exception("Aucun thread  excuter!");
		       else {
		    	     coDemarree = (Coroutine) NoyauSemaphoreTimeSlicing.threadsPrets.getFirst();
                     Coroutine.transfer(coDemarree);
			   }
		   }

	       Coroutine.retablirInterruption();
	   }
	   catch (CoroutineException ce) {
		   throw new Exception(ce.getMessage());
	   }

	}

    /** Excute V sur le smaphore.*/
	public void V() throws Exception {

	   try {
		   Coroutine.masquerInterruption();

           this.n++;

	       /* Est-ce qu'une coroutine est en attente?*/
           if (n <= 0) {
		       Coroutine co = (Coroutine) enAttente.removeFirst();
               NoyauSemaphoreTimeSlicing.threadsPrets.addLast(co);
	       }

	       Coroutine.retablirInterruption();
	   }
	   catch (CoroutineException ce) {
		   throw new Exception(ce.getMessage());
	   }
	}

	public int getCounter() {
		return this.n;
	}
}
