//
//  imprimante version NOIR/BLANC  et Couleur
//


class Imprimante_NOIRBLANC_COULEUR_ver1{
	int no;
	boolean couleur;	
	public Imprimante_NOIRBLANC_COULEUR_ver1(boolean couleur, int no){
		this.couleur = couleur;
		this.no = no;
    }
}

class AllocImpr {

   // contient l'tat des imprimantes (libre ou pas)
   private boolean [] imprCouleur;
   private boolean [] imprNoirBlanc;

   int nbCoulLibre = -1;
   int nbNoirBlancLibre = -1;
   int nbProcAttenteCouleur = 0;
   int nbProcAttenteNoirBlanc = 0;

   public AllocImpr(int maxImprCouleur, int maxImprNoirBlanc) {
      // mise en place du nombre d'imprimantes libres
      this.nbCoulLibre = maxImprCouleur;
      this.nbNoirBlancLibre = maxImprNoirBlanc;

      nbProcAttenteCouleur = 0;
      nbProcAttenteNoirBlanc = 0;
   
      // finalement: initialiser les vecteurs contenant
      // l'tat des imprimantes
      imprCouleur = new boolean[maxImprCouleur];
      initImpr(imprCouleur);
      
      imprNoirBlanc = new boolean[maxImprNoirBlanc];
      initImpr(imprNoirBlanc);
   }


   public synchronized Imprimante_NOIRBLANC_COULEUR_ver1 allouerCouleur() {
      // attendre jusqu' ce qu'il y ait au moins
      // une imprimante couleur libre
    while(nbCoulLibre == 0) {
	 try {
	    nbProcAttenteCouleur++;
	    wait();
	    nbProcAttenteCouleur--;
	 }
	 catch(InterruptedException e) {
	    // ignore exception
	 }
      }
      
      // dcrmente le nombre d'imprimantes couleur libres
      nbCoulLibre--;
      return new Imprimante_NOIRBLANC_COULEUR_ver1(true, get_UN_No_Libre(imprCouleur));
   }

   
   public synchronized Imprimante_NOIRBLANC_COULEUR_ver1 allouerNoirBlanc() {
      // s'il n'y a pas d'imprimante noir-blanc libre ...
      if(nbNoirBlancLibre == 0) {
	 // ... vrifier si on peut prendre une couleur ...
	 if(nbCoulLibre > 0 && nbProcAttenteCouleur == 0) {
	    nbCoulLibre--;
	    return new Imprimante_NOIRBLANC_COULEUR_ver1(true, get_UN_No_Libre(imprCouleur));
	 }
	 // ... ou attendre qu'une noir-blanc se libre.
	 else {
	    while(nbNoirBlancLibre == 0) {
	       try {
		  	nbProcAttenteNoirBlanc++;
		  	wait();
		  	nbProcAttenteNoirBlanc--;
	       }
	       catch(InterruptedException e) {
		  // ignore exception
	       }
	    }
	 }
      }
      
      // dcrmente le nombre d'imprimantes noir-blanc libres
      nbNoirBlancLibre--;

      return new Imprimante_NOIRBLANC_COULEUR_ver1(false, get_UN_No_Libre(imprNoirBlanc));
   }

   
   public synchronized void rendreCouleur(int no) {
      // rend l'imprimante couleur 'no'
      giveBack(imprCouleur, no);
      
      // augmente le nombre d'imprimantes couleur libres
      nbCoulLibre++;

      // notification pour ceux qui attendent
      if(nbProcAttenteCouleur > 0) {
	 notifyAll();
      }
   }

    
   public synchronized void rendreNoirBlanc(int no) {
      // rend l'imprimante noir-blanc 'no'
      giveBack(imprNoirBlanc, no);
      
      // augmente le nombre d'imprimantes couleur libres
      nbNoirBlancLibre++;

      // notification pour ceux qui attendent
      if(nbProcAttenteNoirBlanc > 0) {
	 notifyAll();
      }
   }
   
   private void initImpr(boolean [] impr) {
      for(int i=0; i<impr.length; i++) {
	 impr[i] = true;
      }
   }

   private int get_UN_No_Libre(boolean [] impr) {
      // parcourt les imprimantes et retourne la premire
      // qui est libre
      for(int i=0; i<impr.length; i++) {
	 if(impr[i] == true) {
	    impr[i] = false;
	    return i;
	 }
      }

      throw new RuntimeException(Thread.currentThread().getName() + " : Aucune imprimante libre");
   }

   private void giveBack(boolean [] impr, int no) {
      impr[no] = true;
   }
}
