//
//  lecteur_redacteur_priorite_egale_JAVA.java
//  

public class lecteur_redacteur_priorite_egale_JAVA {
    
    private int readers = 0; /*nombre de lecteurs*/
    private int ticket = 0; /*'ticket' (ordre d'arrive)*/
    private int next = 0; /*prochain processus  s'excuter*/

    public synchronized void debut_lecture() throws InterruptedException {
        wait_for_turn(); /*attendre son tour...*/
        
        readers++; /*indique le nombre de lectures en cours*/
        
        next++; /*rveil du prochain (lectures simultanes)*/
        notifyAll();
    }
	
	
	public synchronized void fin_lecture() {
        readers--; /*dcrmente le nombre de lecteurs*/
        if(readers == 0) { 
            notifyAll(); /*rveille prochains processus*/
        }
    }

    public synchronized void debut_ecriture() throws InterruptedException {
        wait_for_turn();
	
        while(readers != 0) {
            wait();
        }
    }

    public synchronized void fin_ecriture() {
        next++; /*permet au prochain processus de continuer*/
        notifyAll();
    }
    
    public synchronized void wait_for_turn() throws InterruptedException {
        int myticket = ticket; /*prendre un 'ticket'*/
        ticket++;
        while(myticket != next) {
            wait(); /*attendre son tour*/
        }
    }
}

