public class Railways
{
    static final int NB_STEPS = 5;
    // nombre d'etapes necessaires pour une traversee (pays ou tunnel)

    static final int PAUSE = 100;
    // duree d'une pause standard [ms]


    static class Tunnel
    {
	private Basket basket = new Basket();

	Basket getBasket()
	{
	    return basket;
	}

	void cross(Train train)
	{
	    this.enter(train);
	    Railways.cross("tunnel", train);
	    this.leave(train);
	}

	protected synchronized void enter(Train train)
	{
	    System.out.print("ENTREE TUNNEL: ");
	    System.out.println(train.toString());
	}

	protected synchronized void leave(Train train)
	{
	    System.out.print("SORTIE TUNNEL: ");
	    System.out.println(train.toString());
	}
    }


    static class Basket
    {
	private int    stones = 0;
	// nombre de pierres dans le panier.

	synchronized boolean empty()
	{
	    return stones < 1;
	}

	private void searchStone()
	// part chercher une pierre.
	{
	    Railways.constantSleep();
	}

	void putStone()
	// met une pierre dans le panier.
	{
	    searchStone(); // ligne a commenter (ex.1, 4b)
	    synchronized (this) {
		stones ++;
	    }
	}

	synchronized void removeStone()
	// retire une pierre du panier.
	{
	    if (stones > 0)
		stones --;
	}
    }

    
    static class Train
	extends java.lang.Thread
    {
	private final String name;
	private final String country;
	private final Tunnel tunnel;
	
	Train(String name, String country, Tunnel tunnel)
	{
	    this.name    = name;
	    this.country = country;
	    this.tunnel  = tunnel;
	}

	public String toString()
	{
	    return "train " + name;
	}

	private void relax()
	// fait la sieste
	{
	    Railways.constantSleep();
	}

	void tunnelCheckIn()
	// code execute par le cheminot,
	// avant d'entrer dans le tunnel.
	{
	    Basket basket = tunnel.getBasket();
	    // a completer
	    // ...
	}

	void tunnelCheckOut()
	// code execute par le cheminot,
	// apres etre sorti du tunnel.
	{
	    Basket basket = tunnel.getBasket();
	    // a completer
	    // ...
	}
	
	public void run()
	{
	    Railways.cross(country, this);
	    this.tunnelCheckIn();
	    tunnel.cross(this);
	    this.tunnelCheckOut();
	}
    }



    static void cross(String location, Train train)
    {
	for(int i=1; i<NB_STEPS+1; i++) {
	    System.out.println(location + "(" + i + " km): " + train);
	    Railways.pause();
	}
    }

    static void pause()
    {
	Railways.constantSleep();
    }

    static void constantSleep()
    {
	try{
	    Thread.currentThread().sleep(PAUSE);
	} catch (InterruptedException e) {
	    // ignored
	}
    }

    static public void main(String [] args)
	throws java.lang.Exception
    {
	Tunnel tunnel  = new Tunnel();
	Train peruvian = new Train("peruvien", "Perou",   tunnel);
	Train bolivian = new Train("bolivien", "Bolivie", tunnel);
	
	peruvian.start();
	bolivian.start();
    }
}

