/** Classe qui rsout le problme des lecteurs-rdacteurs avec 
 * priorit gale en utilisant les moniteurs de Java
 */
public class ReaderWriter {
    
    private int readers = 0; /*nombre de lecteurs*/
    
    /** La variable ticket et next permettent de garantir la 
     * priorit gale des lecteurs et des rdacteurs. L'ordre 
     * d'accs  la section critique est fait en fonction de 
     * l'ordre d'arrive des processus
     */
    private int ticket = 0; /*'ticket' (ordre d'arrive)*/
    private int next = 0; /*prochain processus  s'excuter*/
    
    /** Debut d'une lecture: le processus attend son tour, 
     * puis incrmente le nombre de lecteurs et passe la 
     * main au prochain.
     */
    public synchronized void start_read() throws InterruptedException {
        wait_for_turn(); /*attendre son tour...*/
        
        readers++; /*indique le nombre de lectures en cours*/
        
        next++; /*rveil du prochain (lectures simultanes)*/
        notifyAll();
    }
    
    /** Debut d'une criture: le processus attend son tour, 
     * puis attend qu'il n'y ait plus de lecteurs en section 
     * critique...
     */
    public synchronized void start_write() throws InterruptedException {
        wait_for_turn();
	
        /* attend la fin des lectures (le while peut 
         * tre remplac par un if)
         */
        while(readers != 0) {
            wait();
        }
    }
    
    /** Fin d'une lecture: le nombre de lecteurs est dcrment. 
     * S'il n'y a plus de lecteurs en section critique, les 
     * autres processus sont notifis
     */
    public synchronized void stop_read() {
        readers--; /*dcrmente le nombre de lecteurs*/
        if(readers == 0) { 
            notifyAll(); /*rveille prochains processus*/
        }
    }
    
    /** Fin d'une criture: la main est passe au prochain processus. 
     * Les processus sont tous notifis de la mise  jour
     */
    public synchronized void stop_write() {
        next++; /*permet au prochain processus de continuer*/
        notifyAll();
    }
    
    /** Attendre son tour: le processus qui appelle cette mthode 
     * prend le prochain ticket et attend que le ticket qui a t 
     * pris soit le mme que next (qui indique le prochain processus 
     *  pouvoir accder  la section critique)
     */
    public synchronized void wait_for_turn() throws InterruptedException {
        int myticket = ticket++; /*prendre un 'ticket'*/
        
        while(myticket != next) {
            wait(); /*attendre son tour*/
        }
    }
}
