public class Tester implements Runnable {

	ReaderWriter monitor = null; /*monitor for reading/writing*/
	boolean writer = false;
	int number = 0;
	
	/** Constructeur: initialise l'objet Tester avec le moniteur, le
	* numro d'identification et un booleen indiquant quel type d'operation
	* doit tre faite
	*
	* @param monitor Moniteur pour les accs en lecture/ecriture
	* @param writer Booleen indiquant si cet objet est un redacteur (true)
	* ou lecteur (false)
	* @param number Numero d'identification...
	*/
	public Tester(ReaderWriter monitor, boolean writer, int number) {
		this.monitor = monitor;
		this.writer = writer;
		this.number = number;
	}

	
	/** Excute le code d'un Tester: commence par dormir entre 0 et 2
	* secondes, puis fait une lecture ou une criture en fonction du type
	* d'opration (writer)
	*/
	public void run() {
		try {
			Thread.sleep((long)(Math.random()*2000)); /*attend entre 0 et 2 secondes*/

			if(writer) write(); /*ecriture*/
			else read(); /*lecture*/
		}
		catch(InterruptedException e) {
			System.err.println("Received an InterruptedException " + e);
			e.printStackTrace();
		}
	}

	/** Fait la partie criture d'un Tester: commence par attendre la section
	* critique, puis affiche un message ds qu'il est en section critique. En
	* section critique, il y a un temps d'attente (0  5 secondes), puis un
	* message indiquant la sortie de la section critique
	*/
	void write() throws InterruptedException {
		System.out.println("\t" + number + " waiting for critical section");
		monitor.start_write();
		System.out.println("WRITER (" + number + ") inside critical section");
		Thread.sleep((long)(Math.random()*5000)); /*attend entre 0 et 5 secondes*/
		System.out.println(number + " leaving critical section");
		monitor.stop_write();
	}
	
	/** Fait la partie lire d'un Tester: commence par attendre la section
	* critique, puis affiche un message ds qu'il est en section critique. En
	* section critique, il y a un temps d'attente (0  5 secondes), puis un
	* message indiquant la sortie de la section critique
	*/
	void read() throws InterruptedException {
		System.out.println("\t" + number + " waiting for critical section");
		monitor.start_read();
		System.out.println("READER (" + number + ") in critical section");
		Thread.sleep((long)(Math.random()*5000)); /*attend entre 0 et 5 secondes*/
		System.out.println(number + " leaving critical section");
		monitor.stop_read();
	}
	
	/** Lancement d'un test: 10 threads bass sur des Tester sont crs, chacun tant
	* soit lecteur (70%), soit rdacteur (30%). Les threads sont tous
	* lancs et tournent en parallle
	*/
	public static void main(String args[]) {
		int howmany = 10;

		ReaderWriter monitor = new ReaderWriter();

		for(int i = 0; i<howmany; i++) {
			(new Thread(new Tester(monitor, Math.random() > 0.7, i))).start();
		}
		
	}


}
