/* auteur: Nicolas Schiper
   date: 30/09/2003 */

package epfl.lsr.SysExpl.couche0;

import java.util.LinkedList;
import java.lang.reflect.*;

public class Coroutine extends Thread {

   /** constante designant une interruption clavier.*/
   public static final int keybIO = 1;

   /*L'objet sur lesquels les coroutines se bloquent.*/
   private static Object obj = new Object();

   /*Indique si une interruption a eu lieu, pendant que
     les interruptions taient masques. */
   private static boolean interruption = false;

   /*Indique si les interruptions sont masques. */
   private static boolean interruptionMasquee = false;

   private Thread co;
   private Method startMethod;

   private boolean suspended;

   private Coroutine(Thread co) throws CoroutineException {

	   Class class_type;

	   try {
		   class_type = Class.forName("java.lang.Thread");

	       this.co = co;
	       this.suspended = false;
	       this.startMethod = class_type.getMethod("start", new Class[]{});
	   }
	   catch (Exception e) {
		   throw new CoroutineException(e.getMessage());
	   }
   }

   /** Veuillez ne pas appeler ce constructeur, mais appeler le
       constructeur: public Coroutine(String className). */
   public Coroutine() {
   }

   /** Cre une coroutine.
       @param className Le nom de la classe dont la mthode "run" est le code de la coroutine.<br>
                        Remarque: Cette classe doit tendre la classe Coroutine.*/
   public Coroutine(String className) throws CoroutineException {

	   Class class_type;
	   Constructor constructor_type;

	   try {
	      class_type = Class.forName(className);
	      constructor_type = class_type.getConstructor(new Class[] {});
	      this.co = (Thread) constructor_type.newInstance(new Object[] {});
	      this.startMethod = class_type.getMethod("start", new Class[]{});
	      this.suspended = false;
       }
       catch (Exception e) {
		  throw new CoroutineException("Couldn't create coroutine!");
       }
   }


   /** Stoppe la coroutine appelante et reprend l'excution de la
       coroutine passe en paramtre.
       @param co La coroutine dont on veut reprendre l'excution.*/
   public static void transfer(Coroutine co) throws CoroutineException {

	  Thread t1 = Thread.currentThread();

	  try {
		 /*bloc synchronis pour que la coroutine qui appelle
		   transfer acquiert le moniteur de obj avant d'appeler wait*/
		 synchronized(obj) {
            if (t1.equals(co))
               throw new CoroutineException("The source and destination coroutines are" +
                                             " identical");

            if (co.isCoAlive()) {
		   	   if(co.isSuspended())
	              co.resumeCo();
	           else
	              co.interruptCo();
			}
		    else
		       co.startCo();

		    IOThread.coroutineCourante = co;

	        /*block la coroutine appelante*/
            obj.wait();
	     }
      }
      catch (InterruptedException ie) {}
   }


   /** Stoppe la coroutine appelante jusqu'a ce que -RETURN- soit entr au clavier.<br>
       En dtail:<br>
   	   (1) La coroutine appelante est stoppe et l'excution de la coroutine passe en
       paramtre est reprise;<br>
       (2) Ds que -RETURN- est entr au clavier, l'excution de la coroutine
       courante est stoppe et la coroutine appelante reprend son excution.<br>
       NB (2) n'a pas lieu aussi longtemps que les interruptions sont masques (cf. mthodes
       masquerInterruption et retablirInterruption)..
       @param co La coroutine dont on veut reprendre l'excution.
       @param interrupt Une seule valeur possible pour ce paramtre: keybIO! */
   public static void ioTransfer(Coroutine co, int interrupt) throws CoroutineException {

	   Coroutine coStoppee = new Coroutine(Thread.currentThread());

	   try {
		  /*bloc synchronis pour que la coroutine qui appelle
		    ioTransfer acquiert le moniteur de obj avant d'appeler wait*/
		  synchronized(obj) {
             if (interrupt == keybIO) {
                /* cr et demarre le thread charg de faire la lecture clavier*/
                IOThread iothread = new IOThread(co, coStoppee);
                iothread.start();

                /* dmarre la coroutine co */
                if (co.isCoAlive()) {
                   if (co.isSuspended())
		              co.resumeCo();
		           else
		              co.interruptCo();
				}
		        else
	               co.startCo();

	            IOThread.coroutineCourante = co;

                /*block la coroutine appelante*/
                obj.wait();
	         }
	         else
	            throw new CoroutineException("Unknown interrupt!");
	      }
	   }
	   catch(InterruptedException ie) {}
   }

   /** Arrte toutes les coroutines et termine la JVM. */
   public static void endSystem() {
	   Runtime rt = Runtime.getRuntime();
	   rt.exit(0);
   }

   /** Masque les interruptions (cf mthode IOTransfer).<br>
       NB Initialement les interruptions ne sont pas masques. */
   public static void masquerInterruption() {
	   interruptionMasquee = true;
   }

   /** Rtablit les interruptions (cf mthode IOTransfer). */
   public static void retablirInterruption() throws CoroutineException {

       Coroutine coStopped;

       try {
           if (interruption)  {
		       IOThread.coroutineCourante.suspendCo();
		       coStopped = IOThread.getCoStopped();

               if (coStopped.isSuspended())
                   coStopped.resumeCo();
		       else
		           coStopped.interruptCo();

		       interruption = false;
		   }

		   interruptionMasquee = false;
	   }
	   catch (Exception e) {
		   throw new CoroutineException(e.getMessage());
	   }
   }


   protected static boolean interruptionMasquee() {
	   return interruptionMasquee;
   }

   protected static void interruptionAeuLieu() {
	   interruption = true;
   }


   /**************************************************************/
   /*                                                            */
   /*  Mthodes de la classe thread renomme pour que            */
   /*  les coroutines supportent les mmes mthodes.   .         */
   /*                                                            */
   /**************************************************************/

   protected void startCo() {
	   try {
           this.startMethod.invoke(this.co, new Object[]{});
	   }
	   catch(Exception e) {
		   e.printStackTrace();
	   }
   }

   protected boolean isCoAlive() {
	   return this.co.isAlive();
   }

   protected void interruptCo() {
      this.co.interrupt();
   }

   protected void resumeCo() {
	   this.co.resume();
	   this.suspended = false;
   }

   protected void suspendCo() {
	   this.co.suspend();
	   this.suspended = true;
   }

   /* Mthode non existante dans la classe Thread. Permet de
      savoir si la coroutine a t suspendue.*/
   protected boolean isSuspended() {
      return this.suspended;
   }
}