<TeXmacs|1.0.3>

<style|article>

<\body>
  <\make-title>
    <title|Recherche Oprationnelle>

    <author|Franois Bochatay & Christina Hauenstein>
  </make-title>

  <section|Programmation linaire>

  <subsection|Formes d'un programme linaire>

  Un programme linaire  deux formes possibles :

  <\enumerate-numeric>
    <item>forme canonique

    <tabular|<tformat|<table|<row|<cell|Maximiser
    <with|mode|math|z=>>|<cell|<with|mode|math|5x<rsub|1>+x<rsub|2>>>|<cell|>|<cell|>|<cell|<htab|5mm><htab|5mm>
    <em|problme de maximisation>>>|<row|<cell|s.c.>|<cell|<with|mode|math|2x<rsub|1>+x<rsub|2>>>|<cell|<with|mode|math|\<leq\>>>|<cell|<with|mode|math|6>>|<cell|<htab|5mm><htab|5mm><htab|5mm><htab|5mm><htab|5mm><htab|5mm>
    <em|contraintes de type <with|mode|math|\<leq\>>>>>|<row|<cell|>|<cell|<with|mode|math|x<rsub|1>+x<rsub|2>>>|<cell|<with|mode|math|\<leq\>>>|<cell|<with|mode|math|4>>|<cell|>>|<row|<cell|>|<cell|<with|mode|math|x<rsub|1,>x<rsub|2>>>|<cell|<with|mode|math|\<geq\>>>|<cell|<with|mode|math|0>>|<cell|
    <em|variables non-ngatives>>>>>>

    <item>forme standard

    <tabular|<tformat|<table|<row|<cell|Maximiser
    <with|mode|math|z=>>|<cell|<with|mode|math|5x<rsub|1>+x<rsub|2>>>|<cell|>|<cell|>|<cell|
    <em|problme de maximisation>>>|<row|<cell|s.c.>|<cell|<with|mode|math|2x<rsub|1>+x<rsub|2>
    +x<rsub|3> >>|<cell|<with|mode|math|=>>|<cell|<with|mode|math|6>>|<cell|
    <em|contraintes de type <with|mode|math|=>>>>|<row|<cell|>|<cell|<with|mode|math|x<rsub|1>+x<rsub|2>+x<rsub|4>>>|<cell|<with|mode|math|=>>|<cell|<with|mode|math|4>>|<cell|>>|<row|<cell|>|<cell|<with|mode|math|x<rsub|1,>x<rsub|2>,x<rsub|3>,x<rsub|4>>>|<cell|<with|mode|math|\<geq\>>>|<cell|<with|mode|math|0>>|<cell|
    <em|variables non-ngatives>>>>>>
  </enumerate-numeric>

  On passe de la forme canonique  la forme standard en rajoutant des
  variables d'carts.

  <subsection|Rgles de transformation>

  <tabular|<tformat|<cwith|1|1|1|1|cell-lsep|0px>|<cwith|1|1|1|1|cell-bsep|0px>|<cwith|1|1|1|1|cell-tsep|0px>|<cwith|1|1|1|1|cell-rsep|20px>|<cwith|3|3|2|2|cell-bsep|3px>|<cwith|1|1|2|2|cell-bsep|3px>|<cwith|2|2|2|2|cell-bsep|3px>|<twith|table-lborder|0px>|<twith|table-rborder|0px>|<twith|table-bborder|0px>|<twith|table-tborder|0px>|<cwith|1|3|1|2|cell-lborder|0px>|<cwith|3|3|2|2|cell-rborder|0px>|<cwith|3|3|2|2|cell-bborder|0px>|<cwith|3|3|2|2|cell-tborder|0px>|<cwith|3|3|1|1|cell-lborder|0px>|<cwith|3|3|1|1|cell-rborder|0px>|<cwith|3|3|1|1|cell-bborder|0px>|<cwith|3|3|1|1|cell-tborder|0px>|<cwith|2|2|1|1|cell-lborder|0px>|<cwith|2|2|1|1|cell-rborder|0px>|<cwith|2|2|1|1|cell-bborder|0px>|<cwith|2|2|1|1|cell-tborder|0px>|<cwith|1|1|1|1|cell-lborder|0px>|<cwith|1|1|1|1|cell-rborder|0px>|<cwith|1|1|1|1|cell-bborder|0px>|<cwith|1|1|1|1|cell-tborder|0px>|<cwith|1|1|2|2|cell-lborder|0px>|<cwith|1|1|2|2|cell-rborder|0px>|<cwith|1|1|2|2|cell-bborder|0px>|<cwith|1|1|2|2|cell-tborder|0px>|<cwith|2|2|2|2|cell-lborder|0px>|<cwith|2|2|2|2|cell-rborder|0px>|<cwith|2|2|2|2|cell-bborder|0px>|<cwith|2|2|2|2|cell-tborder|0px>|<table|<row|<cell|Minimisation
  \<less\>=\<gtr\> Maximisation>|<cell|<with|mode|math|min(z)=max(<wide|z|\<bar\>>)>
  o <with|mode|math|<wide|z|\<bar\>>=-z>>>|<row|<cell|<with|mode|math|\<geq\>>
  \<less\>=\<gtr\> <with|mode|math|\<leq\>>>|<cell|<with|mode|math|a
  x\<geq\>b \<Leftrightarrow\> (-a)x\<leq\>(-b)>>>|<row|<cell|quation
  =\<gtr\> Inquation>|<cell|<with|mode|math|a x = b \<Leftrightarrow\>
  <choice|<tformat|<twith|table-lborder|0>|<twith|table-rborder|0>|<twith|table-bborder|0>|<twith|table-tborder|0>|<table|<row|<cell|a
  \ x \<leq\> b>>|<row|<cell|-a x \<leq\> -b>>>>>>>>|<row|<cell|Inquation
  =\<gtr\> quation>|<cell|<tabular|<tformat|<table|<row|<cell|<with|mode|math|a
  x \<leq\> b \<Leftrightarrow\> a x +s = b<htab|5mm>avec s\<geq\>
  0>>>|<row|<cell|<with|mode|math|a x \<geq\> b \<Leftrightarrow\> a x -s =
  b<htab|5mm>avec s\<geq\> 0>>>>>>>>|<row|<cell|Variable relle =\<gtr\> non
  ngative>|<cell|<with|mode|math|x\<in\>\<bbb-R\>\<Rightarrow\><choice|<tformat|<table|<row|<cell|x=x<rsup|+>-x<rsup|->>>|<row|<cell|x<rsup|+>,x<rsup|->\<geq\>0>>>>>>>>|<row|<cell|Variable
  borne infrieurement>|<cell|<with|mode|math|x\<geq\>b \<Leftrightarrow\>
  <choice|<tformat|<table|<row|<cell|x<rprime|'>=x-b>>|<row|<cell|x<rprime|'>
  \<geq\>0>>>>>>>>|<row|<cell|Maximum / Minimum>|<cell|<with|mode|math|z=min
  \| max {c x,\<ldots\>,c<rprime|'''> x} \<Leftrightarrow\>
  \ <tabular|<tformat|<table|<row|<cell|z=t>>|<row|<cell|s.c. \ \ \ \ \ \ \ t
  (\<leq\> \| \<geq\>)c x \<ldots\>>>|<row|<cell|t\<in\>\<bbb-R\>>>>>>>>>|<row|<cell|Valeurs
  absolues (fct objectif)>|<cell|<with|mode|math|min
  (z)=\|x\|><with|mode|math|\<Leftrightarrow\>
  \ <tabular|<tformat|<table|<row|<cell|z=t>>|<row|<cell|s.c.
  \ \ \ \ \ \ \ \|x\| \<leq\> \ \ t>>|<row|<cell|t\<geq\>0>>>>>>>>|<row|<cell|Valeurs
  absolues (contraintes)>|<cell|<with|mode|math|\|x\|\<leq\>b
  \ \<Leftrightarrow\> \ <stack|<tformat|<table|<row|<cell|x\<leq\>b>>|<row|<cell|x\<geq\>b>>>>>
  \ \ \<Leftrightarrow\><stack|<tformat|<table|<row|<cell|x\<leq\>b>>|<row|<cell|-x\<leq\>b>>>>><htab|5mm>\|x\|\<geq\>
  b > non-linaire !>>>>>

  <subsection|Rgles de dualisation>

  <tabular|<tformat|<twith|table-lborder|1px>|<twith|table-rborder|1px>|<twith|table-bborder|1px>|<twith|table-tborder|1px>|<cwith|1|1|1|3|cell-bborder|1px>|<cwith|4|4|1|3|cell-bborder|1px>|<table|<row|<cell|Problme
  de maximisation>|<cell|<with|mode|math|\<longleftrightarrow\>>>|<cell|Problme
  de minimisation>>|<row|<cell|Variable <with|mode|math|x<rsub|j>\<geq\>0>>|<cell|<with|mode|math|\<longleftrightarrow\>>>|<cell|<with|mode|math|j<rsup|e>>
  contrainte de type <with|mode|math|\<geq\>>>>|<row|<cell|Variable
  <with|mode|math|x<rsub|j>\<in\>\<bbb-R\>>>|<cell|<with|mode|math|\<longleftrightarrow\>>>|<cell|<with|mode|math|j<rsup|e>>
  contrainte de type <with|mode|math|=>>>|<row|<cell|Variable
  <with|mode|math|x<rsub|j>\<leq\>0>>|<cell|<with|mode|math|\<longleftrightarrow\>>>|<cell|<with|mode|math|j<rsup|e>>
  contrainte de type <with|mode|math|\<leq\>>>>|<row|<cell|<with|mode|math|i<rsup|e>>
  contrainte de type <with|mode|math|\<leq\>>>|<cell|<with|mode|math|\<longleftrightarrow\>>>|<cell|Variable
  <with|mode|math|y<rsub|i>\<geq\>0>>>|<row|<cell|<with|mode|math|i<rsup|e>>
  contrainte de type <with|mode|math|=>>|<cell|<with|mode|math|\<longleftrightarrow\>>>|<cell|Variable
  <with|mode|math|y<rsub|i>\<in\>\<bbb-R\>>>>|<row|<cell|<with|mode|math|i<rsup|e>>
  contrainte de type <with|mode|math|\<geq\>>>|<cell|<with|mode|math|\<longleftrightarrow\>>>|<cell|Variable
  <with|mode|math|y<rsub|i>\<leq\>0>>>>>>

  Si un programme linaire primal a <with|mode|math|n> variables et
  <with|mode|math|m> contraintes, alors le programme linaire dual a
  <with|mode|math|m> variables et <with|mode|math|n> contraintes. Les
  variables basiques du programme linaire dual sont associes aux variables
  hors base du programme linaire primal.

  <subsection|Tableaux>

  <subsubsection|Construction>

  Reprenons le problme du point 1.1, sous forme standard

  <tabular|<tformat|<cwith|4|4|4|7|cell-tborder|1px>|<twith|table-lborder|1px>|<twith|table-rborder|1px>|<twith|table-bborder|1px>|<twith|table-tborder|1px>|<cwith|1|1|1|7|cell-bborder|1px>|<cwith|1|4|5|5|cell-lborder|1px>|<cwith|1|4|5|5|cell-rborder|1px>|<cwith|1|4|1|1|cell-rborder|0px>|<cwith|4|4|1|6|cell-tborder|1px>|<cwith|1|4|3|4|cell-lborder|1px>|<cwith|1|4|4|4|cell-lborder|0px>|<table|<row|<cell|<with|mode|math|x<rsub|1>>>|<cell|<with|mode|math|x<rsub|2>>>|<cell|<with|mode|math|x<rsub|3>>>|<cell|<with|mode|math|x<rsub|4>>>|<cell|z>|<cell|>>|<row|<cell|2>|<cell|1>|<cell|1>|<cell|0>|<cell|0>|<cell|<with|mode|math|6>>>|<row|<cell|1>|<cell|1>|<cell|0>|<cell|1<with|mode|math|>>|<cell|<with|mode|math|0>>|<cell|4>>|<row|<cell|-5>|<cell|-1>|<cell|0>|<cell|0>|<cell|1>|<cell|<with|mode|math|>0>>>>>

  <with|mode|math|x<rsub|1> et x<rsub|2>> sont les variables de dcision, et
  <with|mode|math|x<rsub|3> et x<rsub|4>> sont les variables d'cart. La
  dernire colonne est formes des lments  droite des contraintes. La
  dernire ligne est forme des coefficients inverss de la fonction
  objectif.

  <subsubsection|Proprits>

  <\with|par-mode|center>
    <\with|par-mode|left>
      <tabular|<tformat|<cwith|1|6|6|6|cell-lborder|1px>|<cwith|1|6|6|6|cell-rborder|1px>|<cwith|6|6|3|7|cell-tborder|1px>|<twith|table-lborder|1px>|<twith|table-rborder|1px>|<twith|table-bborder|1px>|<twith|table-tborder|1px>|<cwith|6|6|1|5|cell-tborder|1px>|<table|<row|<cell|<with|mode|math|\<alpha\><rsub|11>>>|<cell|>|<cell|<with|mode|math|\<cdots\>>>|<cell|>|<cell|<with|mode|math|\<alpha\><rsub|1n>>>|<cell|0>|<cell|<with|mode|math|\<beta\><rsub|1>>>>|<row|<cell|>|<cell|<with|mode|math|\<ddots\>>>|<cell|>|<cell|>|<cell|>|<cell|>|<cell|>>|<row|<cell|
      <with|mode|math|\<vdots\>>>|<cell|>|<cell|<with|mode|math|\<alpha\><rsub|i
      j>>>|<cell|>|<cell| <with|mode|math|\<vdots\>>>|<cell|<with|mode|math|\<vdots\>>>|<cell|<with|mode|math|\<vdots\>>>>|<row|<cell|>|<cell|>|<cell|>|<cell|<with|mode|math|\<ddots\>>>|<cell|>|<cell|>|<cell|>>|<row|<cell|<with|mode|math|\<alpha\><rsub|m1>>>|<cell|>|<cell|<with|mode|math|\<cdots\>>>|<cell|>|<cell|<with|mode|math|\<alpha\><rsub|m
      n>>>|<cell|0>|<cell|<with|mode|math|\<beta\><rsub|m>>>>|<row|<cell|<with|mode|math|-\<gamma\><rsub|1>>>|<cell|>|<cell|<with|mode|math|\<cdots\>>>|<cell|>|<cell|<with|mode|math|-\<gamma\><rsub|n>>>|<cell|1>|<cell|<with|mode|math|><with|mode|math|z>>>>>>
    </with>
  </with>

  Notation : <with|mode|math|\<oplus\>\<Leftrightarrow\> \<geq\>0 ;
  \<ominus\> \<Leftrightarrow\> \<leq\> 0 ; -\<Leftrightarrow\> \<less\>0 ; +
  \<Leftrightarrow\> \<gtr\>0>

  <tabular|<tformat|<cwith|1|1|1|1|cell-rsep|10px>|<table|<row|<cell|<strong|Primal
  admissible>>|<cell|colonne <with|mode|math|\<beta\>>
  <with|mode|math|\<oplus\>>>>|<row|<cell|<strong|Dual admissible>
  >|<cell|ligne <with|mode|math|\<gamma\>>
  <with|mode|math|\<oplus\>>>>|<row|<cell|<strong|Primal non-born>>|<cell|1
  colonne <with|mode|math|\<alpha\><rsub|i x>><with|mode|math|
  \ \<ominus\>>et <with|mode|math|\<gamma\><rsub|x>>
  <with|mode|math|->>>|<row|<cell|<strong|Dual non-born>>|<cell|1 ligne
  <with|mode|math|\<alpha\><rsub|x j>><with|mode|math|\<oplus\>> et solution
  <with|mode|math|\<beta\><rsub|j>> <with|mode|math|->>>|<row|<cell|<strong|Primal
  dgnr>>|<cell|variable de base primale = 0>>|<row|<cell|<strong|Dual
  dgn<strong|>r>>|<cell|variable de base duale =
  0>>|<row|<cell|<strong|Optimal>>|<cell|primal et dual admissible>>>>>

  <\with|par-first|0px>
    Les variables de base primales sont les variables correspondant aux
    colonnes <with|mode|math|c> de la matrice <with|mode|math|I>, et les
    autres sont les variables de base duales.
  </with>

  <subsection|Algorithme du Simplexe>

  Tout d'abord, il faut formuler le problme de dpart <strong|sous forme
  canonique, puis standard>. De la forme standard, l'on construit le tableau
  initial correspondant.

  Si le tableau initial est admissible, on passe directement  la phase II;
  autrement il faut effectuer la phase I pour le rendre admissible avant de
  passer  la phase II.

  <paragraph|Rgle de Bland>

  Faire rentrer ou sortir de la base la variable de plus petit indice.

  <subsubsection|Phase I>

  Si le rsultat de cette phase est un tableau non-born, le problme n'admet
  pas de solutions.

  <paragraph|Primal>

  <strong|Donne> : tableau non-admissible

  <\enumerate-alpha>
    <item>Ajout d'un second membre artificiel

    <\enumerate-numeric>
      <item>une colonne 0  la droite du tableau =\<gtr\> primal admissible\ 

      <item>On applique l'algorithme du Simplexe primal phase II jusqu' ce
      que le tableau initial soit dual-admissible ou non-born.

      <item>On peut maintenant enlever notre colonne supplmentaire.
    </enumerate-numeric>

    <page-break>

    <item>Construction d'un problme auxiliaire

    <\enumerate-numeric>
      <item>Construire le problme auxiliaire

      <\itemize-minus>
        <item>ajout d'une variable <with|mode|math|x<rsub|0>> valant -1 pour
        les <with|mode|math|\<beta\><rsub|i>\<less\>0>

        <item>la fonction objectif devient <with|mode|math|max
        z<rprime|'>=-x<rsub|0>>

        <item>faire rentrer <with|mode|math|x<rsub|0>> dans la base en
        pivotant sur <with|mode|math|\<alpha\><rsub|j0>> o
        <with|mode|math|\<beta\><rsub|j>\<less\>0> est le min de
        <with|mode|math|\<beta\>>
      </itemize-minus>

      <item>Appliquer l'algorithme du Simplexe phase II sur le problme
      auxiliaire en utilisant la rgle de Bland.

      <item>Solutions

      <\itemize-minus>
        <item>Si <with|mode|math|z<rprime|'>=0>, supprimer tous les ajouts
        fait au point 1. Le tableau est maintenant admissible.

        <item>Si <with|mode|math|z<rprime|'>\<less\>0>, le problme de dpart
        n'admet pas de solutions admissible.\ 
      </itemize-minus>
    </enumerate-numeric>
  </enumerate-alpha>

  <\with|par-left|0pc>
    <strong|Rsultat> : tableau admissible ou non-born
  </with>

  <paragraph|Dual>

  <strong|Donne> : tableau non-admissible

  <\enumerate-numeric>
    <item>On ajoute une fonction objectif artificielle pour rendre le tableau
    dual admissible =\<gtr\> une ligne <tabular|<tformat|<twith|table-lborder|1px>|<twith|table-rborder|1px>|<twith|table-bborder|1px>|<twith|table-tborder|1px>|<cwith|1|1|2|2|cell-lborder|1px>|<cwith|1|1|2|2|cell-rborder|1px>|<cwith|1|1|2|2|cell-bborder|1px>|<cwith|1|1|2|2|cell-tborder|1px>|<table|<row|<cell|0
    <with|mode|math|\<cdots\>> 0>|<cell|1>|<cell|0>>>>>  la fin du tableau.\ 

    <item>On applique l'algorithme du Simplexe dual phase II jusqu' ce que
    le tableau initial soit primal-admissible ou non-born.

    <item>On peut maintenant enlever notre ligne supplmentaire.
  </enumerate-numeric>

  <\with|par-left|0.6cm>
    <\with|par-left|0>
      <strong|Rsultat> : tableau admissible ou non-born
    </with>
  </with>

  <subsubsection|Phase II>

  <paragraph|Primal>

  <strong|Donne> : tableau primal admissible

  <\enumerate-numeric>
    <item>Si le tableau est optimal ou non-born =\<gtr\> ARRT

    <item>Choix du pivot\ 

    <\itemize-minus>
      <item>colonne : <with|mode|math|-\<gamma\><rsub|j>> le plus ngatif (+
      rgle de Bland si le tableau est dgnr)\ 

      <item>ligne : <with|mode|math|min <left|(><frac|\<beta\><rsub|i>|\<alpha\><rsub|ij>><right|)>>
      pour <with|mode|math|\<alpha\><rsub|ij>\<gtr\>0> (quotient
      caractristique; en cas d'galit, on prend le
      <with|mode|math|max(\<alpha\><rsub|i j>)>)
    </itemize-minus>

    <item>Supprimer par oprations sur les lignes les lments en dessus et
    en dessous du pivot

    <item>Retour  1.
  </enumerate-numeric>

  <\with|par-left|1cm>
    <\with|par-left|0.8cm>
      <\with|par-left|0.6cm>
        <\with|par-left|0>
          <strong|Rsultat> : tableau optimal ou non-born
        </with>
      </with>
    </with>
  </with>

  <paragraph|Dual>

  <strong|Donne> : tableau dual admissible

  <\enumerate-numeric>
    <item>Si le tableau est optimal ou non-born =\<gtr\> ARRT

    <item>Choix du pivot

    <\itemize-minus>
      <item>ligne : <with|mode|math|\<beta\><rsub|i>\<less\>0> et rgle de
      Bland

      <item>colonne : <with|mode|math|max
      <left|(><frac|-\<gamma\><rsub|j>|\<alpha\><rsub|ij>><right|)>> pour
      <with|mode|math|\<alpha\><rsub|ij>\<less\>0> (quotient caractristique
      dual)
    </itemize-minus>

    <item>Supprimer par oprations sur les lignes les lments en dessus et
    en dessous du pivot

    <item>Retour  1.
  </enumerate-numeric>

  <\with|par-left|0.6cm>
    <\with|par-left|0>
      <strong|Rsultat> : tableau admissible ou non-born
    </with>
  </with>

  <page-break>

  <subsection|Analyse de sensibilit>

  <subsubsection|Sensibilit du second membre>

  Dans quel intervalle <with|mode|math|\<delta\><rsub|i>> peut varier le
  <with|mode|math|i<rsup|<with|mode|text|me>>> coefficient de
  <with|mode|math|\<beta\>> sans que la base optimale ne change ?

  <\equation*>
    \<delta\><rsub|i><wide|B<rsup|><rsub|i>|\<vect\>><rsup|-1>\<geq\>-<wide|\<beta\>|\<vect\>>
  </equation*>

  <with|mode|math|<wide|B<rsub|i>|\<vect\>><rsup|-1>> est la colonne
  correspondant  la <with|mode|math|i<rsup|<with|mode|text|me>>> variable
  d'cart du systme.\ 

  La nouvelle solution optimale en fonction de
  <with|mode|math|b<rsub|i>\<in\>[\<beta\><rsub|i>\<pm\>\<delta\><rsub|i>]>
  est donne par

  <\equation*>
    <wide|b|\<vect\>>=<matrix|<tformat|<table|<row|<cell|\<beta\><rsub|1>>>|<row|<cell|\<vdots\>>>|<row|<cell|b<rsub|i>>>|<row|<cell|\<vdots\>>>|<row|<cell|\<beta\><rsub|n
    >>>>>><htab|5mm>x<rsub|B><rsup|\<ast\>>=<matrix|<tformat|<table|<row|<cell|x<rsup|\<ast\>><rsub|1>>>|<row|<cell|\<vdots\>>>|<row|<cell|x<rsup|\<ast\>><rsub|n>>>>>>=B<rsup|-1><wide|b|\<vect\>><htab|5mm>z<rprime|'>=<big|sum><rsub|i=1><rsup|n>y<rsub|i>b<rsub|i>
    \ \<Rightarrow\> \ z<rprime|'>\<in\><left|[>z<rsup|\<ast\>>+\<delta\><rsub|i>*y<rsub|i><right|]>
  </equation*>

  o <with|mode|math|B<rsup|-1>> est la matrice correspondant aux variables
  d'cart

  <subsubsection|Sensibilit de la fonction objectif>

  Dans quelle mesure peut-on modifier <with|mode|math|c<rsub|i>> le
  <with|mode|math|i<rsup|<with|mode|text|me>>> coefficient de la fonction
  objectif sans que la base optimale ne change ?

  <\equation*>
    -<wide|\<gamma\>|\<vect\>><rprime|'><rsub|H>=<wide|c|\<vect\>><rprime|'><rsub|B>H-<wide|c|\<vect\>><rprime|'><rsub|H>\<geq\><wide|0|\<vect\>>
  </equation*>

  <with|mode|math|H> est la matrice des variables hors base.

  <\example>
    <with|mode|math|max z =2x<rsub|1>+x<rsub|2>> de tableau optimal\ 

    La base optimale est <with|mode|math|\<cal-B\>={2,1,4}>,
    <with|mode|math|H={3,5}>, <with|mode|math|c<rsub|B>=<matrix|<tformat|<table|<row|<cell|1>|<cell|2>|<cell|0>>>>>>
    dont les entres correspondent aux coefficients de la fonction objectif
    dans l'ordre o ils apparaissent dans la base. Et
    <with|mode|math|c<rsub|H>=<matrix|<tformat|<table|<row|<cell|0>|<cell|0>>>>>>,
    coefficients des variables hors base. Pour trouver
    <with|mode|math|c<rprime|'><rsub|B>>, il faut remplacer la valeur
    correspondante par une inconnue. Si l'on cherche
    <with|mode|math|c<rsub|1>>, <with|mode|math|c<rprime|'><rsub|B>=<matrix|<tformat|<table|<row|<cell|1>|<cell|c<rsub|1>>|<cell|0>>>>>>.
    Il ne reste donc plus qu' rsoudre l'quation.

    \;

    <tabular|<tformat|<cwith|-1|-1|-4|0|cell-tborder|1px>|<twith|table-lborder|1px>|<twith|table-rborder|1px>|<twith|table-bborder|1px>|<twith|table-tborder|1px>|<cwith|1|1|1|0|cell-bborder|1px>|<cwith|1|-1|-2|-2|cell-lborder|1px>|<cwith|1|-1|-2|-2|cell-rborder|1px>|<cwith|1|-1|1|1|cell-rborder|0px>|<cwith|-1|-1|1|-1|cell-tborder|1px>|<cwith|1|-1|-5|-4|cell-lborder|1px>|<cwith|1|-1|-4|-4|cell-lborder|0px>|<cwith|-1|-1|-3|-3|cell-tborder|1px>|<cwith|1|1|-3|-3|cell-bborder|1px>|<cwith|-1|-1|-3|-3|cell-tborder|1px>|<cwith|1|-1|-3|-3|cell-lborder|1px>|<cwith|1|-1|-3|-3|cell-lborder|0px>|<cwith|1|-1|2|-6|cell-rborder|0px>|<cwith|1|-1|-5|-5|cell-lborder|0>|<table|<row|<cell|<with|mode|math|x<rsub|1>>>|<cell|<with|mode|math|x<rsub|2>>>|<cell|<with|mode|math|x<rsub|3>>>|<cell|<with|mode|math|x<rsub|4>>>|<cell|<with|mode|math|x<rsub|5>>>|<cell|z>|<cell|>>|<row|<cell|0>|<cell|1>|<cell|1>|<cell|0>|<cell|-1>|<cell|0>|<cell|1>>|<row|<cell|1>|<cell|0>|<cell|0>|<cell|0>|<cell|1>|<cell|0>|<cell|1>>|<row|<cell|0>|<cell|0>|<cell|1>|<cell|1>|<cell|-2>|<cell|0>|<cell|1>>|<row|<cell|0>|<cell|0>|<cell|1>|<cell|0>|<cell|1>|<cell|1>|<cell|3>>>>>

    \;
  </example>

  <subsubsection|Ajout de contrainte>

  Pour ajouter une contrainte dans un tableau optimal, il faut l'exprimer en
  fonction des variables dans la base optimale. Il faut de plus faire entrer
  la nouvelle variable d'cart dans la base. Enfin, il faut r-appliquer
  l'algorithme du simplexe si ncessaire pour obtenir le nouveau tableau
  optimal.

  <\example>
    \;

    <with|mode|math| T<rsub|opt>= ><tabular|<tformat|<cwith|4|4|4|8|cell-tborder|1px>|<twith|table-lborder|1px>|<twith|table-rborder|1px>|<twith|table-bborder|1px>|<twith|table-tborder|1px>|<cwith|1|1|1|8|cell-bborder|1px>|<cwith|1|4|6|6|cell-lborder|1px>|<cwith|1|4|6|6|cell-rborder|1px>|<cwith|1|4|1|1|cell-rborder|0px>|<cwith|4|4|1|7|cell-tborder|1px>|<cwith|1|4|3|4|cell-lborder|1px>|<cwith|1|4|4|4|cell-lborder|0px>|<cwith|4|4|5|5|cell-tborder|1px>|<cwith|1|1|5|5|cell-bborder|1px>|<cwith|4|4|5|5|cell-tborder|1px>|<cwith|1|4|5|5|cell-lborder|1px>|<cwith|1|4|5|5|cell-lborder|0px>|<cwith|1|4|2|2|cell-rborder|0px>|<cwith|1|4|3|3|cell-lborder|0>|<cwith|2|4|1|7|cell-halign|c>|<table|<row|<cell|<with|mode|math|x<rsub|1>>>|<cell|<with|mode|math|x<rsub|2>>>|<cell|<with|mode|math|x<rsub|3>>>|<cell|<with|mode|math|x<rsub|4>>>|<cell|<with|mode|math|x<rsub|5>>>|<cell|z>|<cell|>>|<row|<cell|1>|<cell|0>|<cell|4>|<cell|1>|<cell|0>|<cell|0>|<cell|8>>|<row|<cell|0>|<cell|1>|<cell|3>|<cell|2>|<cell|1>|<cell|0>|<cell|26>>|<row|<cell|0>|<cell|0>|<cell|13>|<cell|5>|<cell|1>|<cell|1>|<cell|50>>>>>

    On ajoute la contrainte <with|mode|math|2x<rsub|1>+2x<rsub|2>\<leq\>6>,
    donc <with|mode|math|2x<rsub|1>+2x<rsub|2>+x<rsub|6>=6>.\ 

    Du tableau optimal, on tire que <with|mode|math|x<rsub|1>=8-4x<rsub|3>-x<rsub|4>>
    et <with|mode|math|x<rsub|2>=26-3x<rsub|3>-2x<rsub|4>-x<rsub|5>>.\ 

    Dans la base <with|mode|math|\<cal-B\>={1,2,6}>, notre contrainte devient
    <with|mode|math|-14x<rsub|3>-6x<rsub|4>-2x<rsub|5>+x<rsub|6>=-62>.\ 

    Le nouveau tableau est alors

    <tabular|<tformat|<cwith|5|5|4|9|cell-tborder|1px>|<twith|table-lborder|1px>|<twith|table-rborder|1px>|<twith|table-bborder|1px>|<twith|table-tborder|1px>|<cwith|1|1|1|9|cell-bborder|1px>|<cwith|1|5|7|7|cell-lborder|1px>|<cwith|1|5|7|7|cell-rborder|1px>|<cwith|1|5|1|1|cell-rborder|0px>|<cwith|5|5|1|8|cell-tborder|1px>|<cwith|1|5|3|4|cell-lborder|1px>|<cwith|1|5|4|4|cell-lborder|0px>|<cwith|5|5|5|5|cell-tborder|1px>|<cwith|1|1|5|5|cell-bborder|1px>|<cwith|5|5|5|5|cell-tborder|1px>|<cwith|1|5|5|5|cell-lborder|1px>|<cwith|1|5|5|5|cell-lborder|0px>|<cwith|1|5|2|2|cell-rborder|0px>|<cwith|1|5|3|3|cell-lborder|0>|<cwith|2|5|1|8|cell-halign|c>|<table|<row|<cell|<with|mode|math|x<rsub|1>>>|<cell|<with|mode|math|x<rsub|2>>>|<cell|<with|mode|math|x<rsub|3>>>|<cell|<with|mode|math|x<rsub|4>>>|<cell|<with|mode|math|x<rsub|5>>>|<cell|<with|mode|math|x<rsub|6>>>|<cell|z>|<cell|>>|<row|<cell|1>|<cell|0>|<cell|4>|<cell|1>|<cell|0>|<cell|0>|<cell|0>|<cell|8>>|<row|<cell|0>|<cell|1>|<cell|3>|<cell|2>|<cell|1>|<cell|0>|<cell|0>|<cell|26>>|<row|<cell|0>|<cell|0>|<cell|-14>|<cell|-6>|<cell|-2>|<cell|1>|<cell|0>|<cell|-62>>|<row|<cell|0>|<cell|0>|<cell|13>|<cell|5>|<cell|1>|<cell|0>|<cell|1>|<cell|50>>>>>Il
    suffit alors de rendre ce tableau optimal pour trouver la nouvelle
    solution
  </example>

  <page-break>

  <section|Thories des graphes>

  <subsection|Dfinitions>

  Graphe <with|mode|math|G=(V,E,\<varphi\>)> : (sommets, artes/arcs,
  fonction d'incidence).

  Artes/Arcs incidents  <with|mode|math|v> : toutes les artes/arcs qui
  sont connects  <with|mode|math|v>.

  Graphe orient (rseau) =\<gtr\> arcs ; Graphe non orient =\<gtr\> artes.

  Graphe simple = sans boucles (sur lui-mme) ni artes/arcs multiples.

  Multigraphe = avec boucles et/ou artes/arcs multiples.

  Degr : <with|mode|math|deg(v) =>nb d'artes/arcs incidents 
  <with|mode|math|v>.

  <\itemize-minus>
    <item>degr extrieur : <with|mode|math|deg<rsub|+>(v)
    (\<leftarrow\>\<bullet\>\<rightarrow\>)>

    <item>degr intrieur : <with|mode|math|deg<rsub|->(v)(\<rightarrow\>\<bullet\>\<leftarrow\>)>
  </itemize-minus>

  Chane : suite alterne sommets/artes

  <\itemize-minus>
    <item>lmentaire : chaque sommet apparat au plus une fois

    <item>Simple : chaque arte apparat au plus une fois
  </itemize-minus>

  Chemin : suite alterne sommets/arcs

  Cycle : chane dont les extrmits sont confondues

  Arbre : multigraphe non orient sans cycle et connexe

  Fort : ensemble d'arbres non relis entre eux

  Connexit : on peut atteindre n'importe quel sommet

  Connexit forte : connexit + les deux sens de circulation existent.

  Nombre cylcomatique = m-n+p (m artes, n sommets, p composantes connexes)

  <subsection|Matrice d'adjacence et d'incidence>

  Soit un graphe ayant <with|mode|math|n> sommets et <with|mode|math|m>
  artes.

  <subsubsection|Graphe simple non orient>

  <paragraph|Matrice d'adjacence sommets-sommets <with|mode|math|B: n
  \<times\> n>>

  <\equation*>
    b<rsub|ij>=<choice|<tformat|<table|<row|<cell|1 <htab|5mm>si v<rsub|i> et
    v<rsub|j> sont adjacents>>|<row|<cell|0 <htab|5mm>sinon>>>>>
  </equation*>

  <paragraph|Matrice d'incidence sommets-artes <with|mode|math|A: n
  \<times\> m>>

  <\equation*>
    a<rsub|ij>=<choice|<tformat|<table|<row|<cell|1 <htab|5mm>si v<rsub|i>
    \ <with|mode|text|est incident > e<rsub|j>>>|<row|<cell|0
    <htab|5mm>sinon>>>>>
  </equation*>

  <subsubsection|Graphe simple orient>

  <paragraph|Matrice d'adjacence sommets-sommets <with|mode|math|B: n
  \<times\> n>>

  <\equation*>
    b<rsub|ij>=<choice|<tformat|<table|<row|<cell|1 <htab|5mm>si (v<rsub|i>,
    v<rsub|j> )\<in\>E>>|<row|<cell|0 <htab|5mm>sinon>>>>>
  </equation*>

  <paragraph|Matrice d'incidence sommets-artes <with|mode|math|A: n
  \<times\> m>>

  <\equation*>
    a<rsub|ij>=<choice|<tformat|<table|<row|<cell|-1<htab|5mm>si v<rsub|i>
    \ <with|mode|text|est l<rprime|'>extrmit initiale de>
    e<rsub|j>>>|<row|<cell|<htab|5mm><htab|5mm><htab|5mm><htab|5mm>
    \ \ \ \ \ \ \ \ \ 1<htab|5mm>si v<rsub|i> \ <with|mode|text|est
    l<rprime|'>extrmit finale de> e<rsub|j>>>|<row|<cell| \ \ \ \ \ \ \ \ 0
    <htab|5mm>sinon>>>>>
  </equation*>

  <page-break>

  <subsection|Algorithmes>

  <subsubsection|Problme de l'arbre recouvrant de poids minimum>

  Ce problme est aussi appel problme de section minimale.

  <paragraph|Algorithme de Kruskal>

  Donne : graphe connexe avec pondration
  (<with|mode|math|><with|mode|math|\<in\>\<bbb-R\>>) des artes

  <\enumerate-numeric>
    <item>Numroter les artes par ordre croissant en fonction de leurs poids

    <item>Partir d'un arbre solution vide

    <item>Si <with|mode|math|e<rsub|k>> ne forme pas de cycle, l'ajouter 
    l'arbre solution
  </enumerate-numeric>

  Rsultat : arbre recouvrant de poids total minimum

  Exemple :\ 

  <with|mode|math|<tabular|<tformat|<twith|table-lborder|1px>|<twith|table-rborder|1px>|<twith|table-bborder|1px>|<twith|table-tborder|1px>|<twith|table-halign|l>|<cwith|1|1|1|4|cell-bborder|1px>|<cwith|1|5|1|4|cell-rborder|1px>|<cwith|1|5|1|4|cell-halign|c>|<twith|table-valign|b>|<table|<row|<cell|k>|<cell|e<rsub|k>>|<cell|c(e<rsub|k>)>|<cell|\<in\>T>>|<row|<cell|1>|<cell|{v<rsub|1>,v<rsub|3>}>|<cell|1>|<cell|\<checked\>>>|<row|<cell|2>|<cell|{v<rsub|2>,v<rsub|3>}>|<cell|1>|<cell|\<checked\>>>|<row|<cell|3>|<cell|{v<rsub|1>,v<rsub|2>}>|<cell|2>|<cell|\<times\>>>|<row|<cell|\<vdots\>>|<cell|\<vdots\>>|<cell|\<vdots\>>|<cell|\<vdots\>>>>>>><postscript|<tuple|<raw-data|%!PS-Adobe-3.0
  EPSF-3.0\n%%HiResBoundingBox: 0.000000 0.000000 67.000298
  81.000000\n%%Title: (Unknown)\n%%Creator: (Unknown)\n%%CreationDate:
  (Unknown)\n%%For: (Unknown)\n%%DocumentData: Clean7Bit\n%%LanguageLevel:
  2\n%%Pages: 1\n%%BoundingBox: 0 0 67 81\n%%EndComments\n%%BeginProlog\n%%BeginFile:
  cg-pdf.ps\n%%Copyright: Copyright 2000-2002 Apple Computer
  Incorporated.\n%%Copyright: All Rights Reserved.\ncurrentpacking true
  setpacking\n/cg_md 100 dict def\ncg_md begin\n/L3? languagelevel 3 ge
  def\n/bd{bind def}bind def\n/ld{load def}bd\n/xs{exch store}bd\n/xd{exch
  def}bd\n/cmmtx matrix def\nmark\n/sc/setcolor\n/scs/setcolorspace\n/dr/defineresource\n/fr/findresource\n/T/true\n/F/false\n/d/setdash\n/w/setlinewidth\n/J/setlinecap\n/j/setlinejoin\n/M/setmiterlimit\n/i/setflat\n/rc/rectclip\n/rf/rectfill\n/rs/rectstroke\n/f/fill\n/f*/eofill\n/sf/selectfont\n/s/show\n/xS/xshow\n/yS/yshow\n/xyS/xyshow\n/S/stroke\n/m/moveto\n/l/lineto\n/c/curveto\n/h/closepath\n/n/newpath\n/q/gsave\n/Q/grestore\ncounttomark
  2 idiv\n{ld}repeat pop\nL3?{/csq/clipsave ld/csQ/cliprestore
  ld}if\n/SC{\t\n \ \ \ /ColorSpace fr scs\n}bd\n/cgmtx matrix
  def\n/sdmtx{cgmtx currentmatrix pop}bd\n/CM {cgmtx setmatrix}bd\t\t\n/cm
  {cmmtx astore CM concat}bd\t\n/W{clip newpath}bd\n/W*{eoclip
  newpath}bd\nstatusdict begin product end dup (HP) anchorsearch{\n \ \ \ pop
  pop pop\t\n \ \ \ true\n}{\n \ \ \ pop\t\n \ \ (hp) anchorsearch{\n\tpop
  pop true\n \ \ \ }{\n\tpop false\n \ \ \ }ifelse\n}ifelse\n{\t\n \ \ \ {
  \n\t{ \n\t \ \ \ pop pop \n\t \ \ \ (0)dup 0 4 -1 roll put\n\t \ \ \ F
  charpath\n\t}cshow\n \ \ \ }\n}{\n \ \ \ {F charpath}\n}ifelse\n/cply exch
  bd\n/cps {cply stroke}bd\n/pgsave 0 def\n/bp{/pgsave save
  store}bd\n/ep{pgsave restore showpage}def\t\t\n/re{4 2 roll m 1 index 0
  rlineto 0 exch rlineto neg 0 rlineto h}bd\n/scrdict 10 dict def\n/scrmtx
  matrix def\n/patarray 0 def\n/createpat{patarray 3 1 roll
  put}bd\n/makepat{\nscrmtx astore pop\ngsave\ninitgraphics\nCM \npatarray
  exch get\nscrmtx\nmakepattern\ngrestore\nsetpattern\n}bd\n/cg_BeginEPSF{\n
  \ \ \ userdict save/cg_b4_Inc_state exch put\n
  \ \ \ userdict/cg_endepsf/cg_EndEPSF load put\n \ \ \ count
  userdict/cg_op_count 3 -1 roll put \n \ \ \ countdictstack dup array
  dictstack userdict/cg_dict_array 3 -1 roll put\n \ \ \ 3 sub{end}repeat\n
  \ \ \ /showpage {} def\n \ \ \ 0 setgray 0 setlinecap 1 setlinewidth 0
  setlinejoin\n \ \ \ 10 setmiterlimit [] 0 setdash newpath\n \ \ \ false
  setstrokeadjust false setoverprint\t\n}bd\n/cg_EndEPSF{\n \ countdictstack
  3 sub { end } repeat\n \ cg_dict_array 3 1 index length 3 sub getinterval\n
  \ {begin}forall\n \ count userdict/cg_op_count get sub{pop}repeat\n
  \ userdict/cg_b4_Inc_state get restore\n \ F
  setpacking\n}bd\n/cg_biproc{currentfile/RunLengthDecode
  filter}bd\n/cg_aiproc{currentfile/ASCII85Decode filter/RunLengthDecode
  filter}bd\n/ImageDataSource 0 def\nL3?\n{\n \ \ \ /cg_mibiproc{pop
  pop/ImageDataSource{cg_biproc}def}bd\n \ \ \ /cg_miaiproc{pop
  pop/ImageDataSource{cg_aiproc}def}bd\n}{\n \ \ \ /ImageBandMask 0 def\n
  \ \ \ /ImageBandData 0 def\n \ \ \ /cg_mibiproc{\n\tstring/ImageBandMask
  xs\n\tstring/ImageBandData xs\n\t/ImageDataSource{[currentfile/RunLengthDecode
  filter dup ImageBandMask/readstring cvx\n\t \ \ \ /pop cvx dup
  ImageBandData/readstring cvx/pop cvx]cvx bind}bd\n \ \ \ }bd\n
  \ \ \ /cg_miaiproc{\t\n\tstring/ImageBandMask xs\n\tstring/ImageBandData
  xs\n\t/ImageDataSource{[currentfile/ASCII85Decode filter/RunLengthDecode
  filter\n\t \ \ \ dup ImageBandMask/readstring cvx\n\t \ \ \ /pop cvx dup
  ImageBandData/readstring cvx/pop cvx]cvx bind}bd\n
  \ \ \ }bd\n}ifelse\n/imsave 0 def\n/BI{save/imsave xd mark}bd\n/EI{imsave
  restore}bd\n/ID{\ncounttomark 2 idiv\ndup 2 add\t\ndict begin\n{def}
  repeat\npop\t\t\n/ImageType 1 def\n/ImageMatrix[Width 0 0 Height neg 0
  Height]def\ncurrentdict dup/ImageMask known{ImageMask}{F}ifelse
  exch\nL3?{\n \ \ \ dup/MaskedImage known\n \ \ \ { \n\tpop\n\t\<\<\n\t
  \ \ \ /ImageType 3\n\t \ \ \ /InterleaveType 2\n\t \ \ \ /DataDict
  currentdict\n\t \ \ \ /MaskDict\n\t \ \ \ \<\< \ /ImageType 1\n\t\t/Width
  Width\n\t\t/Height Height\n\t\t/ImageMatrix
  ImageMatrix\n\t\t/BitsPerComponent 1\n\t\t/Decode [0
  1]\n\t\tcurrentdict/Interpolate known\n\t\t{/Interpolate Interpolate}if\n\t
  \ \ \ \>\>\n\t\>\>\n \ \ \ }if\n}if\nexch\n{imagemask}{image}ifelse\t\nend\t\n}bd\n/cguidfix{statusdict
  begin mark version end\n{cvr}stopped{cleartomark 0}{exch pop}ifelse\n2012
  lt{dup findfont dup length dict begin\n{1 index/FID ne 2 index/UniqueID ne
  and\n{def} {pop pop} ifelse}forall\ncurrentdict end definefont
  pop\n}{pop}ifelse\n}bd\n/t_array 0 def\n/t_i 0 def\n/t_c 1 string
  def\n/x_proc{ \n \ \ \ exch t_array t_i get add exch moveto\n \ \ \ /t_i
  t_i 1 add store\n}bd\n/y_proc{ \n \ \ \ t_array t_i get add moveto\n
  \ \ \ /t_i t_i 1 add store\n}bd\n/xy_proc{\n \ \ \ \ \ \ \ \n\tt_array t_i
  2 copy 1 add get 3 1 roll get \n\t4 -1 roll add 3 1 roll add moveto\n\t/t_i
  t_i 2 add store\n}bd\n/sop 0 def\t\t\n/cp_proc/x_proc ld
  \t\n/base_charpath\t\t\n{\n \ \ \ /t_array xs\n \ \ \ /t_i 0 def\n \ \ \ {
  \n\tt_c 0 3 -1 roll put\n \ \ \ \ \ \ \ currentpoint\n\tt_c cply sop\n
  \ \ \ \ \ \ \ cp_proc\n \ \ \ }forall\n \ \ \ /t_array 0
  def\n}bd\n/sop/stroke ld\t\t\n/nop{}def\n/xsp/base_charpath
  ld\n/ysp{/cp_proc/y_proc ld base_charpath/cp_proc/x_proc
  ld}bd\n/xysp{/cp_proc/xy_proc ld base_charpath/cp_proc/x_proc
  ld}bd\n/xmp{/sop/nop ld /cp_proc/x_proc ld base_charpath/sop/stroke
  ld}bd\n/ymp{/sop/nop ld /cp_proc/y_proc ld base_charpath/sop/stroke
  ld}bd\n/xymp{/sop/nop ld /cp_proc/xy_proc ld base_charpath/sop/stroke
  ld}bd\n/refnt{ \nfindfont dup length dict copy dup\n/Encoding 4 -1 roll put
  \ndefinefont pop\n}bd\n/renmfont{ \nfindfont dup length dict copy
  definefont pop\n}bd\nend\nsetpacking\n%%EndFile\n%%EndProlog\n%%BeginSetup\n%%EndSetup\n%%Page:
  1 1\n%%PageBoundingBox: 0 0 67 81\n%%BeginPageSetup\ncg_md
  begin\nbp\nsdmtx\n%RBIBeginFontSubset: FPNMOZ+LucidaGrande\n%!PS-TrueTypeFont-1.0000-1.2000-2\n
14
  dict begin/FontName /FPNMOZ+LucidaGrande def\n
/PaintType 0 def\n
/FontType
  1 def\n
/Encoding 256 array 0 1 255{1 index exch/.notdef put}for\n
dup 33
  /v put\n
readonly def\n
/FontMatrix [ 0.00048828125 0 0 0.00048828125 0 0 ]
  def\n
/FontBBox{-1767 -1511 3361 2462}def\n
/UniqueID 4223813
  def\n
currentdict currentfile eexec\n
54544758EC884CF30C3CD503CEDBFF3839C47C3C3333173232E3FDBFF439491DB843E1924E63AA7726BBB0485AB56D93D8C0906F647A47162891E73FFC2A9873C4B1EAC5EEBDFFC4D06084FBD84139DF4583C6E259D10699944D1068C9C45667DCCCFB9B7EA01B606435EDCBD273ABAC093D14085CCBAC149BD7382E842CFE0D7FE4FD2EF589A2471F6074A80A8B675C2F7A50D63AC1EF90D787BADD11633CB01CF6EE3B37AAF9078A69AC4740E9B6525D78BBD839551A1CB80DB8682FA5E87591BBD6EE8B946063A2A58D9CA3685AB305495DC5FB5747EB8A9A059C4976C0FE4EEAB1D56FF47F1E9664ED9F4A7DAB763AF92B2F6CF2FA7DEC24710E0B9096E30F772BA7FEA9BDBE496C42ED2CEB58F54E80BDF57CE7B4DB6CCFE7182F43BF93CCA0767AF95D62C5D2C3DC6AE1E6D139F51A2C63432117F1714C5566572EE9967A715420ABDCD1D7BD74F8450B89965FCC81C6ACA565C5F3CCF91D430D1F953E4F1A645300A98DD8C47CD64555F08F422340A85404EAE0D3229C4F9336B9470CACBD6BBF3395104750A915CC6EAAC197668267B8C62D2764C8CD69FD937CA3C924D997A0EDE7964BEB9EA2F92EF70C5E5DA0AA5567765E71F2B911B3C5586B741EEB93F3C73016EC16BFF283758900903D203992EFC8BAFAF13579C602F38C92725788540EA741B17F7A4B26645F1AC6C6DD680CE8F1F60AEE279148EC39EE9402EDDBB38250DD52287BACC4589C47FA62E17343FA32737214124537096092929B921831333E95D99CD55495FBAF633477D164FF95F58305F50845DCD4E56EB4CC3523A5CACB7CF3CCE3C072269A7F834BAA2E79A5AC2C8809A5E7C726A7A5E4EA1FA287465060D258D05C2E90235BCE50BF47D2CDB2731921E8CFA52ECE836AD4D07E3711AF05C423EEAF2374D22A82461E48D03667B232269545AA747002F49A726ABF480B16AE557C3D9AAC6A0AA609B6C8CEF6E7758A1F618788436EEEA7F312CB2398097654EFC7295D7D8AE9E7EDE0EB\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
cleartomark
  end\n
\n%RBIEndFontSubset\n/FPNMOZ+LucidaGrande
  cguidfix\n/F1.1/FPNMOZ+LucidaGrande renmfont\n%RBIBeginFontSubset:
  HQCKWT+Helvetica\n%!PS-TrueTypeFont-1.0000-0.0000-2\n
14 dict
  begin/FontName /HQCKWT+Helvetica def\n
/PaintType 0 def\n
/FontType 1
  def\n
/Encoding 256 array 0 1 255{1 index exch/.notdef put}for\n
dup 33
  /two put\n
dup 34 /one put\n
dup 35 /three put\n
readonly def\n
/FontMatrix
  [ 0.00048828125 0 0 0.00048828125 0 0 ] def\n
/FontBBox{-342 -914 2036
  2100}def\n
/UniqueID 4069639 def\n
currentdict currentfile
  eexec\n
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n
12006B8298A14F6416B7DC538A765B4447DA7250A931F9150F59326EB8A9E8F141106A7A2DC6409E2AB1E110DCF0AB786430C75AF8F7996C1798112D4247C595399B54C1817F099083D925F8F82D9D33C5DE3CCB9FE97D5E103F7DB0A834E9A7A75893EC66340B0E4C6F0EEDEF43415BF9FCF447340CBEA4DC9B3512B219C89485B87D09C06AA9B038A21E3245AFD3711E76650874\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
cleartomark
  end\n
\n%RBIEndFontSubset\n/HQCKWT+Helvetica
  cguidfix\n/F2.1/HQCKWT+Helvetica renmfont\n[ /CIEBasedA 5 dict dup begin
  /WhitePoint [ 0.9505 1.0000 1.0891 ] def \n/DecodeA { { 1.8008 \ exp } bind
  \ exec} bind \ndef \n/MatrixA [ 0.9642 1.0000 0.8249 ] def \n/RangeLMN [
  0.0 2.0000 0.0 2.0000 0.0 2.0000 ] def \n/DecodeLMN [ { 0.9857 \ mul} bind
  { 1.0000 \ mul} bind { 1.3202 \ mul} bind ] def \nend ] /Cs1
  exch/ColorSpace dr pop\n%%EndPageSetup\n/Cs1 SC\n1 sc\nq\n0 0 67.000298 81
  rc\n1 0 0 -1 -16.999901 77.999977 cm\n16.999901 -3.00002 68 81\nrf\n0 sc\n1
  0 0 -1 17.500099 13.499977 cm\n/F1.1[ 9 0 0 -9 0 0]sf\n-5.5 0.5
  m\n(!)s\n/F2.1[ 7 0 0 -7 0 0]sf\n-0.84179688 3.5 m\n(!)s\n1 0 0 -1
  23.500099 66.499977 cm\n/F1.1[ 9 0 0 -9 0 0]sf\n-5.5 0.5 m\n(!)s\n/F2.1[ 7
  0 0 -7 0 0]sf\n-0.84179688 3.5 m\n(")s\n0.60000002 i\n1 0 0 -1 -16.499901
  77.499977 cm\n37.5 57 m\n37.5 18 l\nS\n0 i\n1 0 0 -1 15.545555 43.816044
  cm\n/F2.1[ 9 0 0 -9 0 0]sf\n-4 1.5 m\n(!)s\n0.60000002 i\n1 0 0 -1
  -16.499901 77.499977 cm\n39.267765 13.732235 m\n40.24408 14.708546 40.24408
  16.291454 39.267765 17.267765 c\n38.291454 18.24408 36.708546 18.24408
  35.732235 17.267765 c\n34.75592 16.291454 34.75592 14.708546 35.732235
  13.732235 c\n36.708546 12.75592 38.291454 12.75592 39.267765 13.732235
  c\nS\n39.300804 57.765896 m\n62.6992 35.234104 l\nS\n0 i\n1 0 0 -1
  42.119751 25.716763 cm\n-4 1.5 m\n(")s\n0.60000002 i\n1 0 0 -1 -16.499901
  77.499977 cm\n39.580524 16.887016 m\n62.419476 32.112984 l\nS\n0 i\n1 0 0
  -1 40.427353 57.789207 cm\n-4 1.5 m\n(")s\n1 0 0 -1 50.500099 48.499977
  cm\n/F1.1[ 9 0 0 -9 0 0]sf\n-5.5 0.5 m\n(!)s\n/F2.1[ 7 0 0 -7 0
  0]sf\n-0.84179688 3.5 m\n(#)s\n0.60000002 i\n1 0 0 -1 -16.499901 77.499977
  cm\n39.267765 57.732235 m\n40.24408 58.708546 40.24408 60.291454 39.267765
  61.267765 c\n38.291454 62.24408 36.708546 62.24408 35.732235 61.267765
  c\n34.75592 60.291454 34.75592 58.708546 35.732235 57.732235 c\n36.708546
  56.75592 38.291454 56.75592 39.267765 57.732235 c\nS\n66.267761 31.732235
  m\n67.24408 32.708546 67.24408 34.291454 66.267761 35.267765 c\n65.291458
  36.24408 63.708546 36.24408 62.732235 35.267765 c\n61.75592 34.291454
  61.75592 32.708546 62.732235 31.732235 c\n63.708546 30.75592 65.291458
  30.75592 66.267761 31.732235 c\nS\nep\nend\n%%Trailer\n%%EOF\n>|eps>||||||>

  Pour obtenir l'arbre recouvrant de poids maximum, trier dans l'ordre
  dcroissant.

  <paragraph|Algorithme de Prim>

  Donne : graphe connexe avec pondration
  (<with|mode|math|><with|mode|math|\<in\>\<bbb-R\>>) des artes

  <\enumerate-numeric>
    <item>Partir d'un arbre solution vide

    <item>Choisir arbitrairement un sommet

    <item>Choisir l'arte la plus conomique pour rejoindre un sommet pas
    encore visit depuis un sommet dj prsent dans l'arbre solution.
    Ajouter cette arte  l'arbre solution.
  </enumerate-numeric>

  Rsultat : arbre recouvrant de poids total minimum

  <subsubsection|Problmes de plus courts chemins>

  On cherche le plus court chemin d'un sommet source
  <with|mode|math|v<rsub|s>>  tous les autres.

  <paragraph|Principe d'optimalit de Bellman>

  Un plus court chemin est form de plus courts chemins.

  <paragraph|Algorithme gnrique>

  <\enumerate-numeric>
    <item>On part d'un vecteur <with|mode|math|\<lambda\>> initial :
    <with|mode|math|\<lambda\><rsub|s>=0 \ et \<lambda\><rsub|i>=\<infty\>
    \ \<forall\>i\<neq\>s>

    <item>On tient  jour une liste de candidats <with|mode|math|L>,
    initialement <with|mode|math|L={v<rsub|s>}>.

    <item>Tant que <with|mode|math|L\<neq\>\<varnothing\>>, on retire le
    sommet <with|mode|math|v<rsub|i>> de <with|mode|math|L> et on teste ses
    successeurs <with|mode|math|j:>

    si <with|mode|math|\<lambda\><rsub|j>\<gtr\>\<lambda\><rsub|i>+c<rsub|i
    j>> , on pose <with|mode|math|\<lambda\><rsub|j>=\<lambda\><rsub|i>+c<rsub|i
    j>> et on introduit <with|mode|math|j> dans <with|mode|math|L>.\ 
  </enumerate-numeric>

  <\example>
    \;

    <with|mode|math|<tabular|<tformat|<twith|table-lborder|1px>|<twith|table-rborder|1px>|<twith|table-bborder|1px>|<twith|table-tborder|1px>|<twith|table-halign|l>|<cwith|1|1|1|4|cell-bborder|1px>|<cwith|1|5|1|4|cell-rborder|1px>|<cwith|1|5|1|4|cell-halign|c>|<cwith|6|6|1|4|cell-rborder|1px>|<cwith|6|6|1|4|cell-halign|c>|<cwith|4|4|4|4|cell-valign|b>|<twith|table-valign|b>|<table|<row|<cell|<with|mode|text|Itration>>|<cell|L>|<cell|\<lambda\>>|<cell|<with|mode|text|Sommet
    retir de> L>>|<row|<cell|0>|<cell|{v<rsub|1>}>|<cell|(0,
    \<infty\>,\<infty\>,\<infty\>)>|<cell|->>|<row|<cell|1>|<cell|{v<rsub|2>,v<rsub|3>}>|<cell|1>|<cell|v<rsub|1>>>|<row|<cell|2>|<cell|{v<rsub|3>,v<rsub|4>}>|<cell|2>|<cell|v<rsub|2>>>|<row|<cell|\<vdots\>>|<cell|\<vdots\>>|<cell|\<vdots\>>|<cell|\<vdots\>>>|<row|<cell|5>|<cell|\<varnothing\>>|<cell|(0,2,1,4)>|<cell|v<rsub|2>>>>>>><postscript|<tuple|<raw-data|%!PS-Adobe-3.0
    EPSF-3.0\n%%HiResBoundingBox: 0.000000 0.000000 123.998001
    73.000801\n%%Title: (Unknown)\n%%Creator: (Unknown)\n%%CreationDate:
    (Unknown)\n%%For: (Unknown)\n%%DocumentData: Clean7Bit\n%%LanguageLevel:
    2\n%%Pages: 1\n%%BoundingBox: 0 0 123
    73\n%%EndComments\n%%BeginProlog\n%%BeginFile: cg-pdf.ps\n%%Copyright:
    Copyright 2000-2002 Apple Computer Incorporated.\n%%Copyright: All Rights
    Reserved.\ncurrentpacking true setpacking\n/cg_md 100 dict def\ncg_md
    begin\n/L3? languagelevel 3 ge def\n/bd{bind def}bind def\n/ld{load
    def}bd\n/xs{exch store}bd\n/xd{exch def}bd\n/cmmtx matrix
    def\nmark\n/sc/setcolor\n/scs/setcolorspace\n/dr/defineresource\n/fr/findresource\n/T/true\n/F/false\n/d/setdash\n/w/setlinewidth\n/J/setlinecap\n/j/setlinejoin\n/M/setmiterlimit\n/i/setflat\n/rc/rectclip\n/rf/rectfill\n/rs/rectstroke\n/f/fill\n/f*/eofill\n/sf/selectfont\n/s/show\n/xS/xshow\n/yS/yshow\n/xyS/xyshow\n/S/stroke\n/m/moveto\n/l/lineto\n/c/curveto\n/h/closepath\n/n/newpath\n/q/gsave\n/Q/grestore\ncounttomark
    2 idiv\n{ld}repeat pop\nL3?{/csq/clipsave ld/csQ/cliprestore
    ld}if\n/SC{\t\n \ \ \ /ColorSpace fr scs\n}bd\n/cgmtx matrix
    def\n/sdmtx{cgmtx currentmatrix pop}bd\n/CM {cgmtx setmatrix}bd\t\t\n/cm
    {cmmtx astore CM concat}bd\t\n/W{clip newpath}bd\n/W*{eoclip
    newpath}bd\nstatusdict begin product end dup (HP) anchorsearch{\n
    \ \ \ pop pop pop\t\n \ \ \ true\n}{\n \ \ \ pop\t\n \ \ (hp)
    anchorsearch{\n\tpop pop true\n \ \ \ }{\n\tpop false\n
    \ \ \ }ifelse\n}ifelse\n{\t\n \ \ \ { \n\t{ \n\t \ \ \ pop pop \n\t
    \ \ \ (0)dup 0 4 -1 roll put\n\t \ \ \ F charpath\n\t}cshow\n
    \ \ \ }\n}{\n \ \ \ {F charpath}\n}ifelse\n/cply exch bd\n/cps {cply
    stroke}bd\n/pgsave 0 def\n/bp{/pgsave save store}bd\n/ep{pgsave restore
    showpage}def\t\t\n/re{4 2 roll m 1 index 0 rlineto 0 exch rlineto neg 0
    rlineto h}bd\n/scrdict 10 dict def\n/scrmtx matrix def\n/patarray 0
    def\n/createpat{patarray 3 1 roll put}bd\n/makepat{\nscrmtx astore
    pop\ngsave\ninitgraphics\nCM \npatarray exch
    get\nscrmtx\nmakepattern\ngrestore\nsetpattern\n}bd\n/cg_BeginEPSF{\n
    \ \ \ userdict save/cg_b4_Inc_state exch put\n
    \ \ \ userdict/cg_endepsf/cg_EndEPSF load put\n \ \ \ count
    userdict/cg_op_count 3 -1 roll put \n \ \ \ countdictstack dup array
    dictstack userdict/cg_dict_array 3 -1 roll put\n \ \ \ 3 sub{end}repeat\n
    \ \ \ /showpage {} def\n \ \ \ 0 setgray 0 setlinecap 1 setlinewidth 0
    setlinejoin\n \ \ \ 10 setmiterlimit [] 0 setdash newpath\n \ \ \ false
    setstrokeadjust false setoverprint\t\n}bd\n/cg_EndEPSF{\n
    \ countdictstack 3 sub { end } repeat\n \ cg_dict_array 3 1 index length
    3 sub getinterval\n \ {begin}forall\n \ count userdict/cg_op_count get
    sub{pop}repeat\n \ userdict/cg_b4_Inc_state get restore\n \ F
    setpacking\n}bd\n/cg_biproc{currentfile/RunLengthDecode
    filter}bd\n/cg_aiproc{currentfile/ASCII85Decode filter/RunLengthDecode
    filter}bd\n/ImageDataSource 0 def\nL3?\n{\n \ \ \ /cg_mibiproc{pop
    pop/ImageDataSource{cg_biproc}def}bd\n \ \ \ /cg_miaiproc{pop
    pop/ImageDataSource{cg_aiproc}def}bd\n}{\n \ \ \ /ImageBandMask 0 def\n
    \ \ \ /ImageBandData 0 def\n \ \ \ /cg_mibiproc{\n\tstring/ImageBandMask
    xs\n\tstring/ImageBandData xs\n\t/ImageDataSource{[currentfile/RunLengthDecode
    filter dup ImageBandMask/readstring cvx\n\t \ \ \ /pop cvx dup
    ImageBandData/readstring cvx/pop cvx]cvx bind}bd\n \ \ \ }bd\n
    \ \ \ /cg_miaiproc{\t\n\tstring/ImageBandMask xs\n\tstring/ImageBandData
    xs\n\t/ImageDataSource{[currentfile/ASCII85Decode filter/RunLengthDecode
    filter\n\t \ \ \ dup ImageBandMask/readstring cvx\n\t \ \ \ /pop cvx dup
    ImageBandData/readstring cvx/pop cvx]cvx bind}bd\n
    \ \ \ }bd\n}ifelse\n/imsave 0 def\n/BI{save/imsave xd mark}bd\n/EI{imsave
    restore}bd\n/ID{\ncounttomark 2 idiv\ndup 2 add\t\ndict begin\n{def}
    repeat\npop\t\t\n/ImageType 1 def\n/ImageMatrix[Width 0 0 Height neg 0
    Height]def\ncurrentdict dup/ImageMask known{ImageMask}{F}ifelse
    exch\nL3?{\n \ \ \ dup/MaskedImage known\n \ \ \ { \n\tpop\n\t\<\<\n\t
    \ \ \ /ImageType 3\n\t \ \ \ /InterleaveType 2\n\t \ \ \ /DataDict
    currentdict\n\t \ \ \ /MaskDict\n\t \ \ \ \<\< \ /ImageType 1\n\t\t/Width
    Width\n\t\t/Height Height\n\t\t/ImageMatrix
    ImageMatrix\n\t\t/BitsPerComponent 1\n\t\t/Decode [0
    1]\n\t\tcurrentdict/Interpolate known\n\t\t{/Interpolate
    Interpolate}if\n\t \ \ \ \>\>\n\t\>\>\n
    \ \ \ }if\n}if\nexch\n{imagemask}{image}ifelse\t\nend\t\n}bd\n/cguidfix{statusdict
    begin mark version end\n{cvr}stopped{cleartomark 0}{exch pop}ifelse\n2012
    lt{dup findfont dup length dict begin\n{1 index/FID ne 2 index/UniqueID
    ne and\n{def} {pop pop} ifelse}forall\ncurrentdict end definefont
    pop\n}{pop}ifelse\n}bd\n/t_array 0 def\n/t_i 0 def\n/t_c 1 string
    def\n/x_proc{ \n \ \ \ exch t_array t_i get add exch moveto\n \ \ \ /t_i
    t_i 1 add store\n}bd\n/y_proc{ \n \ \ \ t_array t_i get add moveto\n
    \ \ \ /t_i t_i 1 add store\n}bd\n/xy_proc{\n \ \ \ \ \ \ \ \n\tt_array
    t_i 2 copy 1 add get 3 1 roll get \n\t4 -1 roll add 3 1 roll add
    moveto\n\t/t_i t_i 2 add store\n}bd\n/sop 0 def\t\t\n/cp_proc/x_proc ld
    \t\n/base_charpath\t\t\n{\n \ \ \ /t_array xs\n \ \ \ /t_i 0 def\n
    \ \ \ { \n\tt_c 0 3 -1 roll put\n \ \ \ \ \ \ \ currentpoint\n\tt_c cply
    sop\n \ \ \ \ \ \ \ cp_proc\n \ \ \ }forall\n \ \ \ /t_array 0
    def\n}bd\n/sop/stroke ld\t\t\n/nop{}def\n/xsp/base_charpath
    ld\n/ysp{/cp_proc/y_proc ld base_charpath/cp_proc/x_proc
    ld}bd\n/xysp{/cp_proc/xy_proc ld base_charpath/cp_proc/x_proc
    ld}bd\n/xmp{/sop/nop ld /cp_proc/x_proc ld base_charpath/sop/stroke
    ld}bd\n/ymp{/sop/nop ld /cp_proc/y_proc ld base_charpath/sop/stroke
    ld}bd\n/xymp{/sop/nop ld /cp_proc/xy_proc ld base_charpath/sop/stroke
    ld}bd\n/refnt{ \nfindfont dup length dict copy dup\n/Encoding 4 -1 roll
    put \ndefinefont pop\n}bd\n/renmfont{ \nfindfont dup length dict copy
    definefont pop\n}bd\nend\nsetpacking\n%%EndFile\n%%EndProlog\n%%BeginSetup\n%%EndSetup\n%%Page:
    1 1\n%%PageBoundingBox: 0 0 123 73\n%%BeginPageSetup\ncg_md
    begin\nbp\nsdmtx\n%RBIBeginFontSubset:
    DEHPOZ+LucidaGrande\n%!PS-TrueTypeFont-1.0000-1.2000-2\n
14 dict
    begin/FontName /DEHPOZ+LucidaGrande def\n
/PaintType 0 def\n
/FontType 1
    def\n
/Encoding 256 array 0 1 255{1 index exch/.notdef put}for\n
dup 33
    /v put\n
readonly def\n
/FontMatrix [ 0.00048828125 0 0 0.00048828125 0 0
    ] def\n
/FontBBox{-1767 -1511 3361 2462}def\n
/UniqueID 4223813
    def\n
currentdict currentfile eexec\n
54544758EC884CF30C3CD503CEDBFF3839C47C3C3333173232E3FDBFF439491DB843E1924E63AA7726BBB0485AB56D93D8C0906F647A47162891E73FFC2A9873C4B1EAC5EEBDFFC4D06084FBD84139DF4583C6E259D10699944D1068C9C45667DCCCFB9B7EA01B606435EDCBD273ABAC093D14085CCBAC149BD7382E842CFE0D7FE4FD2EF589A2471F6074A80A8B675C2F7A50D63AC1EF90D787BADD11633CB01CF6EE3B37AAF9078A69AC4740E9B6525D78BBD839551A1CB80DB8682FA5E87591BBD6EE8B946063A2A58D9CA3685AB305495DC5FB5747EB8A9A059C4976C0FE4EEAB1D56FF47F1E9664ED9F4A7DAB763AF92B2F6CF2FA7DEC24710E0B9096E30F772BA7FEA9BDBE496C42ED2CEB58F54E80BDF57CE7B4DB6CCFE7182F43BF93CCA0767AF95D62C5D2C3DC6AE1E6D139F51A2C63432117F1714C5566572EE9967A715420ABDCD1D7BD74F8450B89965FCC81C6ACA565C5F3CCF91D430D1F953E4F1A645300A98DD8C47CD64555F08F422340A85404EAE0D3229C4F9336B9470CACBD6BBF3395104750A915CC6EAAC197668267B8C62D2764C8CD69FD937CA3C924D997A0EDE7964BEB9EA2F92EF70C5E5DA0AA5567765E71F2B911B3C5586B741EEB93F3C73016EC16BFF283758900903D203992EFC8BAFAF13579C602F38C92725788540EA741B17F7A4B26645F1AC6C6DD680CE8F1F60AEE279148EC39EE9402EDDBB38250DD52287BACC4589C47FA62E17343FA32737214124537096092929B921831333E95D99CD55495FBAF633477D164FF95F58305F50845DCD4E56EB4CC3523A5CACB7CF3CCE3C072269A7F834BAA2E79A5AC2C8809A5E7C726A7A5E4EA1FA287465060D258D05C2E90235BCE50BF47D2CDB2731921E8CFA52ECE836AD4D07E3711AF05C423EEAF2374D22A82461E48D03667B232269545AA747002F49A726ABF480B16AE557C3D9AAC6A0AA609B6C8CEF6E7758A1F618788436EEEA7F312CB2398097654EFC7295D7D8AE9E7EDE0EB\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
cleartomark
    end\n
\n%RBIEndFontSubset\n/DEHPOZ+LucidaGrande
    cguidfix\n/F1.1/DEHPOZ+LucidaGrande renmfont\n%RBIBeginFontSubset:
    NTFOUX+Helvetica\n%!PS-TrueTypeFont-1.0000-0.0000-2\n
14 dict
    begin/FontName /NTFOUX+Helvetica def\n
/PaintType 0 def\n
/FontType 1
    def\n
/Encoding 256 array 0 1 255{1 index exch/.notdef put}for\n
dup 33
    /one put\n
dup 34 /S put\n
dup 35 /o put\n
dup 36 /u put\n
dup 37 /r
    put\n
dup 38 /c put\n
dup 39 /e put\n
dup 40 /three put\n
dup 41 /two
    put\n
dup 42 /four put\n
readonly def\n
/FontMatrix [ 0.00048828125 0 0
    0.00048828125 0 0 ] def\n
/FontBBox{-342 -914 2036 2100}def\n
/UniqueID
    4069639 def\n
currentdict currentfile
    eexec\n
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n
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n
D3B525C99FF4F11A4EF8CBB86CD2383C79B85C481D16D5F7BC27104148892D720ED67044C563C21E5A22F026E0CA19A63FA8DE9CE867E8CEB63F185B521BCDA16660CD61EBB6D3FCE495A29B337B7871C563CD84F89B86598A33033E4BEA17D8FDBAB44422720CFBEF342A8AD0078B0FF6E69D7228E10F0121A8ADE873B71320B4A07D69A09BF10F35D48557DF8F64AA96A7B2431574554F4905E8E20A89F9A255E2AC3BE88C69851826EE2742431A646787CF1ABCEF65EE16\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
cleartomark
    end\n
\n%RBIEndFontSubset\n/NTFOUX+Helvetica
    cguidfix\n/F2.1/NTFOUX+Helvetica renmfont\n[ /CIEBasedA 5 dict dup begin
    /WhitePoint [ 0.9505 1.0000 1.0891 ] def \n/DecodeA { { 1.8008 \ exp }
    bind \ exec} bind \ndef \n/MatrixA [ 0.9642 1.0000 0.8249 ] def
    \n/RangeLMN [ 0.0 2.0000 0.0 2.0000 0.0 2.0000 ] def \n/DecodeLMN [ {
    0.9857 \ mul} bind { 1.0000 \ mul} bind { 1.3202 \ mul} bind ] def \nend
    ] /Cs1 exch/ColorSpace dr pop\n%%EndPageSetup\n/Cs1 SC\n1 sc\nq\n0 0
    123.998 73.000801 rc\n1 0 0 -1 -5.99998 71.000778 cm\n5.99998 -2.9992189
    124.00001 74\nrf\n0 sc\n1 0 0 -1 23.500019 31.500778 cm\n/F1.1[ 9 0 0 -9
    0 0]sf\n-5.5 0.5 m\n(!)s\n/F2.1[ 7 0 0 -7 0 0]sf\n-0.84179688 3.5
    m\n(!)s\n1 0 0 -1 21.500019 40.250778 cm\n/F2.1[ 6 0 0 -6 0 0]sf\n-11
    -0.5 m\n("#$%&')[ 4.001953 3.336914 3.336914 1.998047 3.000000 3.336914 ]
    xS\n1 0 0 -1 61.500019 13.500778 cm\n/F1.1[ 9 0 0 -9 0 0]sf\n-5.5 0.5
    m\n(!)s\n/F2.1[ 7 0 0 -7 0 0]sf\n-0.84179688 3.5 m\n(\\()s\n1 0 0 -1
    68.500023 58.500778 cm\n/F1.1[ 9 0 0 -9 0 0]sf\n-5.5 0.5 m\n(!)s\n/F2.1[
    7 0 0 -7 0 0]sf\n-0.84179688 3.5 m\n(\\))s\n0.60000002 i\n1 0 0 -1
    -5.49998 70.500778 cm\n33.792355 32.500771 m\n62.799145 19.856785
    l\nS\nCM\n60.965946 52.242336 m\n56.699783 52.019039 l\n58.674206
    51.24337 l\n57.299164 50.643997 l\n58.674206 51.24337 l\n57.89854
    49.268951 l\nh\n60.965946 52.242336 m\nf\n1 0 0 -1 -5.49998 70.500778
    cm\n66.465927 18.258442 m\n62.199764 18.481739 l\n64.174187 19.257408
    l\n62.799145 19.856781 l\n64.174187 19.257408 l\n63.398521 21.231827
    l\nh\n66.465927 18.258442 m\nS\n0 i\n1 0 0 -1 44.180984 48.892624
    cm\n/F2.1[ 9 0 0 -9 0 0]sf\n-4 1.5 m\n(\\()s\n0.60000002 i\n1 0 0 -1
    -5.49998 70.500778 cm\n72.267761 14.732235 m\n73.24408 15.708546 73.24408
    17.291454 72.267761 18.267765 c\n71.291458 19.24408 69.708542 19.24408
    68.732239 18.267765 c\n67.75592 17.291454 67.75592 15.708546 68.732239
    14.732235 c\n69.708542 13.75592 71.291458 13.75592 72.267761 14.732235
    c\nS\n33.748089 34.595222 m\n68.251915 51.404778 l\nS\n0 i\n1 0 0 -1
    45.048477 21.653347 cm\n-4 1.5 m\n(!)s\n0.60000002 i\n1 0 0 -1 -5.49998
    70.500778 cm\n69 20 m\n69 43.099998 l\nS\nCM\n63.500019 23.40078
    m\n65.000023 27.40078 l\n63.500019 25.90078 l\n63.500019 27.40078
    l\n63.500019 25.90078 l\n62.000019 27.40078 l\nh\n63.500019 23.40078
    m\nf\n1 0 0 -1 -5.49998 70.500778 cm\n69 47.099998 m\n70.5 43.099998
    l\n69 44.599998 l\n69 43.099998 l\n69 44.599998 l\n67.5 43.099998
    l\nh\n69 47.099998 m\nS\n0 i\n1 0 0 -1 61.681835 37.036072 cm\n-4 1.5
    m\n(!)s\n1 0 0 -1 107.50002 41.500778 cm\n/F1.1[ 9 0 0 -9 0 0]sf\n-5.5
    0.5 m\n(!)s\n/F2.1[ 7 0 0 -7 0 0]sf\n-0.84179688 3.5 m\n(*)s\n0.60000002
    i\n1 0 0 -1 -5.49998 70.500778 cm\n33.267765 31.732235 m\n34.24408
    32.708546 34.24408 34.291454 33.267765 35.267765 c\n32.291454 36.24408
    30.708546 36.24408 29.732235 35.267765 c\n28.75592 34.291454 28.75592
    32.708546 29.732235 31.732235 c\n30.708546 30.75592 32.291454 30.75592
    33.267765 31.732235 c\nS\n72.267761 50.732235 m\n73.24408 51.708546
    73.24408 53.291454 72.267761 54.267765 c\n71.291458 55.24408 69.708542
    55.24408 68.732239 54.267765 c\n67.75592 53.291454 67.75592 51.708546
    68.732239 50.732235 c\n69.708542 49.75592 71.291458 49.75592 72.267761
    50.732235 c\nS\n102.76861 30.214157 m\n72.801437 17.478111
    l\nS\nCM\n100.94996 38.722057 m\n97.855347 41.667114 l\n98.649132
    39.699909 l\n97.268639 40.286621 l\n98.649132 39.699909 l\n96.681923
    38.906124 l\nh\n100.94996 38.722057 m\nf\n1 0 0 -1 -5.49998 70.500778
    cm\n106.44994 31.778721 m\n103.35532 28.833664 l\n104.14911 30.800869
    l\n102.76862 30.214157 l\n104.14911 30.800869 l\n102.1819 31.594654
    l\nh\n106.44994 31.778721 m\nS\n0 i\n1 0 0 -1 88.665222 49.869789
    cm\n/F2.1[ 9 0 0 -9 0 0]sf\n-4 1.5 m\n(\\))s\n0.60000002 i\n1 0 0 -1
    -5.49998 70.500778 cm\n102.91186 37.10437 m\n72.758804 51.427067
    l\nS\nCM\n101.02499 35.112637 m\n96.768295 34.751328 l\n98.7668 34.039993
    l\n97.41188 33.396408 l\n98.7668 34.039993 l\n98.055466 32.041492
    l\nh\n101.02499 35.112637 m\nf\n1 0 0 -1 -5.49998 70.500778 cm\n106.52497
    35.388142 m\n102.26827 35.749451 l\n104.26678 36.460785 l\n102.91186
    37.10437 l\n104.26678 36.460785 l\n103.55544 38.459286 l\nh\n106.52497
    35.388142 m\nS\n0 i\n1 0 0 -1 89.083809 21.389088 cm\n-4 1.5
    m\n(\\()s\n0.60000002 i\n1 0 0 -1 -5.49998 70.500778 cm\n112.26776
    31.732235 m\n113.24408 32.708546 113.24408 34.291454 112.26776 35.267765
    c\n111.29146 36.24408 109.70854 36.24408 108.73224 35.267765 c\n107.75592
    34.291454 107.75592 32.708546 108.73224 31.732235 c\n109.70854 30.75592
    111.29146 30.75592 112.26776 31.732235 c\nS\n73 25.900002 m\n73 49
    l\nS\nCM\n67.500023 48.600777 m\n66.000023 44.600777 l\n67.500023
    46.100777 l\n67.500023 44.600777 l\n67.500023 46.100777 l\n69.000023
    44.600777 l\nh\n67.500023 48.600777 m\nf\n1 0 0 -1 -5.49998 70.500778
    cm\n73 21.900002 m\n71.5 25.900002 l\n73 24.400002 l\n73 25.900002 l\n73
    24.400002 l\n74.5 25.900002 l\nh\n73 21.900002 m\nS\n0 i\n1 0 0 -1
    72.954567 31.136074 cm\n-4 1.5 m\n(!)s\nep\nend\n%%Trailer\n%%EOF\n>|eps>||||||>
  </example>

  <page-break>

  <paragraph|Algorithme de Dijkstra>

  Donnes : rseau connexe avec pondration non-ngative

  <\enumerate-numeric>
    <item><with|mode|math|\<lambda\><rsub|s>=0 \ \ ;
    \<lambda\><rsub|i>=\<infty\> \ \<forall\>i\<neq\>s> ;
    <with|mode|math|p(i)=null> ; <with|mode|math|T=V>

    <item>tant que <with|mode|math|T\<neq\>\<varnothing\> >:

    <\itemize-minus>
      <item>Soit <with|mode|math|i> le sommet de <with|mode|math|T> de plus
      petite tiquette <with|mode|math|\<lambda\><rsub|i>>

      <item>Si un tel sommet n'existe pas
      (<with|mode|math|\<lambda\><rsub|j>=\<infty\> \<forall\>j\<in\>T>) :
      STOP, les sommets encore dans <with|mode|math|T> ne sont pas
      atteignables depuis <with|mode|math|s>

      <item>Sinon, retirer <with|mode|math|i> de <with|mode|math|T> et tester
      tous les successeurs <with|mode|math|j> de <with|mode|math|i> encore
      dans <with|mode|math|T> :

      si <with|mode|math|\<lambda\><rsub|j>\<gtr\>\<lambda\><rsub|i>+c<rsub|i
      j>> , on pose <with|mode|math|\<lambda\><rsub|j>=\<lambda\><rsub|i>+c<rsub|i
      j>> et <with|mode|math|p(j)=i>.
    </itemize-minus>
  </enumerate-numeric>

  <\example>
    \;

    <with|mode|math|<tabular|<tformat|<twith|table-lborder|1px>|<twith|table-rborder|1px>|<twith|table-bborder|1px>|<twith|table-tborder|1px>|<twith|table-halign|l>|<cwith|1|1|1|4|cell-bborder|1px>|<cwith|1|3|1|4|cell-rborder|1px>|<cwith|1|3|1|4|cell-halign|c>|<cwith|2|2|3|3|cell-halign|c>|<twith|table-valign|b>|<table|<row|<cell|<with|mode|text|Itr.>>|<cell|i<rsub|min>>|<cell|<with|mode|text|tiquettes
    >\<lambda\><rsub|i> / <with|mode|text|Prdcesseurs>
    p(i)>|<cell|<with|mode|text|>T>>|<row|<cell|<stack|<tformat|<table|<row|<cell|0>>|<row|<cell|1>>|<row|<cell|2>>|<row|<cell|3>>|<row|<cell|4>>>>>>|<cell|<stack|<tformat|<table|<row|<cell|->>|<row|<cell|v<rsub|1>>>|<row|<cell|v<rsub|3>>>|<row|<cell|v<rsub|2>>>|<row|<cell|v<rsub|4>>>>>>>|<cell|<tabular|<tformat|<cwith|1|5|1|4|cell-halign|c>|<table|<row|<cell|0/null>|<cell|\<infty\>/null>|<cell|\<infty\>/null>|<cell|\<infty\>/null>>|<row|<cell|0/null>|<cell|3/v<rsub|1>>|<cell|1/v<rsub|1>>|<cell|\<infty\>/null>>|<row|<cell|>|<cell|2/v<rsub|3>>|<cell|1/v<rsub|1>>|<cell|4/v<rsub|3>>>|<row|<cell|>|<cell|2/v<rsub|3>>|<cell|>|<cell|4/v<rsub|3>>>|<row|<cell|>|<cell|>|<cell|>|<cell|4/v<rsub|3>>>>>>>|<cell|<stack|<tformat|<table|<row|<cell|{v<rsub|1>,v<rsub|2>,v<rsub|3>,v<rsub|4>}>>|<row|<cell|{v<rsub|2>,v<rsub|3>,v<rsub|4>}>>|<row|<cell|{v<rsub|2>,v<rsub|4>}>>|<row|<cell|{v<rsub|4>}>>|<row|<cell|\<varnothing\>>>>>>>>>>>><postscript|<tuple|<raw-data|%!PS-Adobe-3.0
    EPSF-3.0\n%%HiResBoundingBox: 0.000000 0.000000 123.998001
    73.000801\n%%Title: (Unknown)\n%%Creator: (Unknown)\n%%CreationDate:
    (Unknown)\n%%For: (Unknown)\n%%DocumentData: Clean7Bit\n%%LanguageLevel:
    2\n%%Pages: 1\n%%BoundingBox: 0 0 123
    73\n%%EndComments\n%%BeginProlog\n%%BeginFile: cg-pdf.ps\n%%Copyright:
    Copyright 2000-2002 Apple Computer Incorporated.\n%%Copyright: All Rights
    Reserved.\ncurrentpacking true setpacking\n/cg_md 100 dict def\ncg_md
    begin\n/L3? languagelevel 3 ge def\n/bd{bind def}bind def\n/ld{load
    def}bd\n/xs{exch store}bd\n/xd{exch def}bd\n/cmmtx matrix
    def\nmark\n/sc/setcolor\n/scs/setcolorspace\n/dr/defineresource\n/fr/findresource\n/T/true\n/F/false\n/d/setdash\n/w/setlinewidth\n/J/setlinecap\n/j/setlinejoin\n/M/setmiterlimit\n/i/setflat\n/rc/rectclip\n/rf/rectfill\n/rs/rectstroke\n/f/fill\n/f*/eofill\n/sf/selectfont\n/s/show\n/xS/xshow\n/yS/yshow\n/xyS/xyshow\n/S/stroke\n/m/moveto\n/l/lineto\n/c/curveto\n/h/closepath\n/n/newpath\n/q/gsave\n/Q/grestore\ncounttomark
    2 idiv\n{ld}repeat pop\nL3?{/csq/clipsave ld/csQ/cliprestore
    ld}if\n/SC{\t\n \ \ \ /ColorSpace fr scs\n}bd\n/cgmtx matrix
    def\n/sdmtx{cgmtx currentmatrix pop}bd\n/CM {cgmtx setmatrix}bd\t\t\n/cm
    {cmmtx astore CM concat}bd\t\n/W{clip newpath}bd\n/W*{eoclip
    newpath}bd\nstatusdict begin product end dup (HP) anchorsearch{\n
    \ \ \ pop pop pop\t\n \ \ \ true\n}{\n \ \ \ pop\t\n \ \ (hp)
    anchorsearch{\n\tpop pop true\n \ \ \ }{\n\tpop false\n
    \ \ \ }ifelse\n}ifelse\n{\t\n \ \ \ { \n\t{ \n\t \ \ \ pop pop \n\t
    \ \ \ (0)dup 0 4 -1 roll put\n\t \ \ \ F charpath\n\t}cshow\n
    \ \ \ }\n}{\n \ \ \ {F charpath}\n}ifelse\n/cply exch bd\n/cps {cply
    stroke}bd\n/pgsave 0 def\n/bp{/pgsave save store}bd\n/ep{pgsave restore
    showpage}def\t\t\n/re{4 2 roll m 1 index 0 rlineto 0 exch rlineto neg 0
    rlineto h}bd\n/scrdict 10 dict def\n/scrmtx matrix def\n/patarray 0
    def\n/createpat{patarray 3 1 roll put}bd\n/makepat{\nscrmtx astore
    pop\ngsave\ninitgraphics\nCM \npatarray exch
    get\nscrmtx\nmakepattern\ngrestore\nsetpattern\n}bd\n/cg_BeginEPSF{\n
    \ \ \ userdict save/cg_b4_Inc_state exch put\n
    \ \ \ userdict/cg_endepsf/cg_EndEPSF load put\n \ \ \ count
    userdict/cg_op_count 3 -1 roll put \n \ \ \ countdictstack dup array
    dictstack userdict/cg_dict_array 3 -1 roll put\n \ \ \ 3 sub{end}repeat\n
    \ \ \ /showpage {} def\n \ \ \ 0 setgray 0 setlinecap 1 setlinewidth 0
    setlinejoin\n \ \ \ 10 setmiterlimit [] 0 setdash newpath\n \ \ \ false
    setstrokeadjust false setoverprint\t\n}bd\n/cg_EndEPSF{\n
    \ countdictstack 3 sub { end } repeat\n \ cg_dict_array 3 1 index length
    3 sub getinterval\n \ {begin}forall\n \ count userdict/cg_op_count get
    sub{pop}repeat\n \ userdict/cg_b4_Inc_state get restore\n \ F
    setpacking\n}bd\n/cg_biproc{currentfile/RunLengthDecode
    filter}bd\n/cg_aiproc{currentfile/ASCII85Decode filter/RunLengthDecode
    filter}bd\n/ImageDataSource 0 def\nL3?\n{\n \ \ \ /cg_mibiproc{pop
    pop/ImageDataSource{cg_biproc}def}bd\n \ \ \ /cg_miaiproc{pop
    pop/ImageDataSource{cg_aiproc}def}bd\n}{\n \ \ \ /ImageBandMask 0 def\n
    \ \ \ /ImageBandData 0 def\n \ \ \ /cg_mibiproc{\n\tstring/ImageBandMask
    xs\n\tstring/ImageBandData xs\n\t/ImageDataSource{[currentfile/RunLengthDecode
    filter dup ImageBandMask/readstring cvx\n\t \ \ \ /pop cvx dup
    ImageBandData/readstring cvx/pop cvx]cvx bind}bd\n \ \ \ }bd\n
    \ \ \ /cg_miaiproc{\t\n\tstring/ImageBandMask xs\n\tstring/ImageBandData
    xs\n\t/ImageDataSource{[currentfile/ASCII85Decode filter/RunLengthDecode
    filter\n\t \ \ \ dup ImageBandMask/readstring cvx\n\t \ \ \ /pop cvx dup
    ImageBandData/readstring cvx/pop cvx]cvx bind}bd\n
    \ \ \ }bd\n}ifelse\n/imsave 0 def\n/BI{save/imsave xd mark}bd\n/EI{imsave
    restore}bd\n/ID{\ncounttomark 2 idiv\ndup 2 add\t\ndict begin\n{def}
    repeat\npop\t\t\n/ImageType 1 def\n/ImageMatrix[Width 0 0 Height neg 0
    Height]def\ncurrentdict dup/ImageMask known{ImageMask}{F}ifelse
    exch\nL3?{\n \ \ \ dup/MaskedImage known\n \ \ \ { \n\tpop\n\t\<\<\n\t
    \ \ \ /ImageType 3\n\t \ \ \ /InterleaveType 2\n\t \ \ \ /DataDict
    currentdict\n\t \ \ \ /MaskDict\n\t \ \ \ \<\< \ /ImageType 1\n\t\t/Width
    Width\n\t\t/Height Height\n\t\t/ImageMatrix
    ImageMatrix\n\t\t/BitsPerComponent 1\n\t\t/Decode [0
    1]\n\t\tcurrentdict/Interpolate known\n\t\t{/Interpolate
    Interpolate}if\n\t \ \ \ \>\>\n\t\>\>\n
    \ \ \ }if\n}if\nexch\n{imagemask}{image}ifelse\t\nend\t\n}bd\n/cguidfix{statusdict
    begin mark version end\n{cvr}stopped{cleartomark 0}{exch pop}ifelse\n2012
    lt{dup findfont dup length dict begin\n{1 index/FID ne 2 index/UniqueID
    ne and\n{def} {pop pop} ifelse}forall\ncurrentdict end definefont
    pop\n}{pop}ifelse\n}bd\n/t_array 0 def\n/t_i 0 def\n/t_c 1 string
    def\n/x_proc{ \n \ \ \ exch t_array t_i get add exch moveto\n \ \ \ /t_i
    t_i 1 add store\n}bd\n/y_proc{ \n \ \ \ t_array t_i get add moveto\n
    \ \ \ /t_i t_i 1 add store\n}bd\n/xy_proc{\n \ \ \ \ \ \ \ \n\tt_array
    t_i 2 copy 1 add get 3 1 roll get \n\t4 -1 roll add 3 1 roll add
    moveto\n\t/t_i t_i 2 add store\n}bd\n/sop 0 def\t\t\n/cp_proc/x_proc ld
    \t\n/base_charpath\t\t\n{\n \ \ \ /t_array xs\n \ \ \ /t_i 0 def\n
    \ \ \ { \n\tt_c 0 3 -1 roll put\n \ \ \ \ \ \ \ currentpoint\n\tt_c cply
    sop\n \ \ \ \ \ \ \ cp_proc\n \ \ \ }forall\n \ \ \ /t_array 0
    def\n}bd\n/sop/stroke ld\t\t\n/nop{}def\n/xsp/base_charpath
    ld\n/ysp{/cp_proc/y_proc ld base_charpath/cp_proc/x_proc
    ld}bd\n/xysp{/cp_proc/xy_proc ld base_charpath/cp_proc/x_proc
    ld}bd\n/xmp{/sop/nop ld /cp_proc/x_proc ld base_charpath/sop/stroke
    ld}bd\n/ymp{/sop/nop ld /cp_proc/y_proc ld base_charpath/sop/stroke
    ld}bd\n/xymp{/sop/nop ld /cp_proc/xy_proc ld base_charpath/sop/stroke
    ld}bd\n/refnt{ \nfindfont dup length dict copy dup\n/Encoding 4 -1 roll
    put \ndefinefont pop\n}bd\n/renmfont{ \nfindfont dup length dict copy
    definefont pop\n}bd\nend\nsetpacking\n%%EndFile\n%%EndProlog\n%%BeginSetup\n%%EndSetup\n%%Page:
    1 1\n%%PageBoundingBox: 0 0 123 73\n%%BeginPageSetup\ncg_md
    begin\nbp\nsdmtx\n%RBIBeginFontSubset:
    DEHPOZ+LucidaGrande\n%!PS-TrueTypeFont-1.0000-1.2000-2\n
14 dict
    begin/FontName /DEHPOZ+LucidaGrande def\n
/PaintType 0 def\n
/FontType 1
    def\n
/Encoding 256 array 0 1 255{1 index exch/.notdef put}for\n
dup 33
    /v put\n
readonly def\n
/FontMatrix [ 0.00048828125 0 0 0.00048828125 0 0
    ] def\n
/FontBBox{-1767 -1511 3361 2462}def\n
/UniqueID 4223813
    def\n
currentdict currentfile eexec\n
54544758EC884CF30C3CD503CEDBFF3839C47C3C3333173232E3FDBFF439491DB843E1924E63AA7726BBB0485AB56D93D8C0906F647A47162891E73FFC2A9873C4B1EAC5EEBDFFC4D06084FBD84139DF4583C6E259D10699944D1068C9C45667DCCCFB9B7EA01B606435EDCBD273ABAC093D14085CCBAC149BD7382E842CFE0D7FE4FD2EF589A2471F6074A80A8B675C2F7A50D63AC1EF90D787BADD11633CB01CF6EE3B37AAF9078A69AC4740E9B6525D78BBD839551A1CB80DB8682FA5E87591BBD6EE8B946063A2A58D9CA3685AB305495DC5FB5747EB8A9A059C4976C0FE4EEAB1D56FF47F1E9664ED9F4A7DAB763AF92B2F6CF2FA7DEC24710E0B9096E30F772BA7FEA9BDBE496C42ED2CEB58F54E80BDF57CE7B4DB6CCFE7182F43BF93CCA0767AF95D62C5D2C3DC6AE1E6D139F51A2C63432117F1714C5566572EE9967A715420ABDCD1D7BD74F8450B89965FCC81C6ACA565C5F3CCF91D430D1F953E4F1A645300A98DD8C47CD64555F08F422340A85404EAE0D3229C4F9336B9470CACBD6BBF3395104750A915CC6EAAC197668267B8C62D2764C8CD69FD937CA3C924D997A0EDE7964BEB9EA2F92EF70C5E5DA0AA5567765E71F2B911B3C5586B741EEB93F3C73016EC16BFF283758900903D203992EFC8BAFAF13579C602F38C92725788540EA741B17F7A4B26645F1AC6C6DD680CE8F1F60AEE279148EC39EE9402EDDBB38250DD52287BACC4589C47FA62E17343FA32737214124537096092929B921831333E95D99CD55495FBAF633477D164FF95F58305F50845DCD4E56EB4CC3523A5CACB7CF3CCE3C072269A7F834BAA2E79A5AC2C8809A5E7C726A7A5E4EA1FA287465060D258D05C2E90235BCE50BF47D2CDB2731921E8CFA52ECE836AD4D07E3711AF05C423EEAF2374D22A82461E48D03667B232269545AA747002F49A726ABF480B16AE557C3D9AAC6A0AA609B6C8CEF6E7758A1F618788436EEEA7F312CB2398097654EFC7295D7D8AE9E7EDE0EB\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
cleartomark
    end\n
\n%RBIEndFontSubset\n/DEHPOZ+LucidaGrande
    cguidfix\n/F1.1/DEHPOZ+LucidaGrande renmfont\n%RBIBeginFontSubset:
    NTFOUX+Helvetica\n%!PS-TrueTypeFont-1.0000-0.0000-2\n
14 dict
    begin/FontName /NTFOUX+Helvetica def\n
/PaintType 0 def\n
/FontType 1
    def\n
/Encoding 256 array 0 1 255{1 index exch/.notdef put}for\n
dup 33
    /one put\n
dup 34 /S put\n
dup 35 /o put\n
dup 36 /u put\n
dup 37 /r
    put\n
dup 38 /c put\n
dup 39 /e put\n
dup 40 /three put\n
dup 41 /two
    put\n
dup 42 /four put\n
readonly def\n
/FontMatrix [ 0.00048828125 0 0
    0.00048828125 0 0 ] def\n
/FontBBox{-342 -914 2036 2100}def\n
/UniqueID
    4069639 def\n
currentdict currentfile
    eexec\n
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n
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n
D3B525C99FF4F11A4EF8CBB86CD2383C79B85C481D16D5F7BC27104148892D720ED67044C563C21E5A22F026E0CA19A63FA8DE9CE867E8CEB63F185B521BCDA16660CD61EBB6D3FCE495A29B337B7871C563CD84F89B86598A33033E4BEA17D8FDBAB44422720CFBEF342A8AD0078B0FF6E69D7228E10F0121A8ADE873B71320B4A07D69A09BF10F35D48557DF8F64AA96A7B2431574554F4905E8E20A89F9A255E2AC3BE88C69851826EE2742431A646787CF1ABCEF65EE16\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
cleartomark
    end\n
\n%RBIEndFontSubset\n/NTFOUX+Helvetica
    cguidfix\n/F2.1/NTFOUX+Helvetica renmfont\n[ /CIEBasedA 5 dict dup begin
    /WhitePoint [ 0.9505 1.0000 1.0891 ] def \n/DecodeA { { 1.8008 \ exp }
    bind \ exec} bind \ndef \n/MatrixA [ 0.9642 1.0000 0.8249 ] def
    \n/RangeLMN [ 0.0 2.0000 0.0 2.0000 0.0 2.0000 ] def \n/DecodeLMN [ {
    0.9857 \ mul} bind { 1.0000 \ mul} bind { 1.3202 \ mul} bind ] def \nend
    ] /Cs1 exch/ColorSpace dr pop\n%%EndPageSetup\n/Cs1 SC\n1 sc\nq\n0 0
    123.998 73.000801 rc\n1 0 0 -1 -5.99998 71.000778 cm\n5.99998 -2.9992189
    124.00001 74\nrf\n0 sc\n1 0 0 -1 23.500019 31.500778 cm\n/F1.1[ 9 0 0 -9
    0 0]sf\n-5.5 0.5 m\n(!)s\n/F2.1[ 7 0 0 -7 0 0]sf\n-0.84179688 3.5
    m\n(!)s\n1 0 0 -1 21.500019 40.250778 cm\n/F2.1[ 6 0 0 -6 0 0]sf\n-11
    -0.5 m\n("#$%&')[ 4.001953 3.336914 3.336914 1.998047 3.000000 3.336914 ]
    xS\n1 0 0 -1 61.500019 13.500778 cm\n/F1.1[ 9 0 0 -9 0 0]sf\n-5.5 0.5
    m\n(!)s\n/F2.1[ 7 0 0 -7 0 0]sf\n-0.84179688 3.5 m\n(\\()s\n1 0 0 -1
    68.500023 58.500778 cm\n/F1.1[ 9 0 0 -9 0 0]sf\n-5.5 0.5 m\n(!)s\n/F2.1[
    7 0 0 -7 0 0]sf\n-0.84179688 3.5 m\n(\\))s\n0.60000002 i\n1 0 0 -1
    -5.49998 70.500778 cm\n33.792355 32.500771 m\n62.799145 19.856785
    l\nS\nCM\n60.965946 52.242336 m\n56.699783 52.019039 l\n58.674206
    51.24337 l\n57.299164 50.643997 l\n58.674206 51.24337 l\n57.89854
    49.268951 l\nh\n60.965946 52.242336 m\nf\n1 0 0 -1 -5.49998 70.500778
    cm\n66.465927 18.258442 m\n62.199764 18.481739 l\n64.174187 19.257408
    l\n62.799145 19.856781 l\n64.174187 19.257408 l\n63.398521 21.231827
    l\nh\n66.465927 18.258442 m\nS\n0 i\n1 0 0 -1 44.180984 48.892624
    cm\n/F2.1[ 9 0 0 -9 0 0]sf\n-4 1.5 m\n(\\()s\n0.60000002 i\n1 0 0 -1
    -5.49998 70.500778 cm\n72.267761 14.732235 m\n73.24408 15.708546 73.24408
    17.291454 72.267761 18.267765 c\n71.291458 19.24408 69.708542 19.24408
    68.732239 18.267765 c\n67.75592 17.291454 67.75592 15.708546 68.732239
    14.732235 c\n69.708542 13.75592 71.291458 13.75592 72.267761 14.732235
    c\nS\n33.748089 34.595222 m\n68.251915 51.404778 l\nS\n0 i\n1 0 0 -1
    45.048477 21.653347 cm\n-4 1.5 m\n(!)s\n0.60000002 i\n1 0 0 -1 -5.49998
    70.500778 cm\n69 20 m\n69 43.099998 l\nS\nCM\n63.500019 23.40078
    m\n65.000023 27.40078 l\n63.500019 25.90078 l\n63.500019 27.40078
    l\n63.500019 25.90078 l\n62.000019 27.40078 l\nh\n63.500019 23.40078
    m\nf\n1 0 0 -1 -5.49998 70.500778 cm\n69 47.099998 m\n70.5 43.099998
    l\n69 44.599998 l\n69 43.099998 l\n69 44.599998 l\n67.5 43.099998
    l\nh\n69 47.099998 m\nS\n0 i\n1 0 0 -1 61.681835 37.036072 cm\n-4 1.5
    m\n(!)s\n1 0 0 -1 107.50002 41.500778 cm\n/F1.1[ 9 0 0 -9 0 0]sf\n-5.5
    0.5 m\n(!)s\n/F2.1[ 7 0 0 -7 0 0]sf\n-0.84179688 3.5 m\n(*)s\n0.60000002
    i\n1 0 0 -1 -5.49998 70.500778 cm\n33.267765 31.732235 m\n34.24408
    32.708546 34.24408 34.291454 33.267765 35.267765 c\n32.291454 36.24408
    30.708546 36.24408 29.732235 35.267765 c\n28.75592 34.291454 28.75592
    32.708546 29.732235 31.732235 c\n30.708546 30.75592 32.291454 30.75592
    33.267765 31.732235 c\nS\n72.267761 50.732235 m\n73.24408 51.708546
    73.24408 53.291454 72.267761 54.267765 c\n71.291458 55.24408 69.708542
    55.24408 68.732239 54.267765 c\n67.75592 53.291454 67.75592 51.708546
    68.732239 50.732235 c\n69.708542 49.75592 71.291458 49.75592 72.267761
    50.732235 c\nS\n102.76861 30.214157 m\n72.801437 17.478111
    l\nS\nCM\n100.94996 38.722057 m\n97.855347 41.667114 l\n98.649132
    39.699909 l\n97.268639 40.286621 l\n98.649132 39.699909 l\n96.681923
    38.906124 l\nh\n100.94996 38.722057 m\nf\n1 0 0 -1 -5.49998 70.500778
    cm\n106.44994 31.778721 m\n103.35532 28.833664 l\n104.14911 30.800869
    l\n102.76862 30.214157 l\n104.14911 30.800869 l\n102.1819 31.594654
    l\nh\n106.44994 31.778721 m\nS\n0 i\n1 0 0 -1 88.665222 49.869789
    cm\n/F2.1[ 9 0 0 -9 0 0]sf\n-4 1.5 m\n(\\))s\n0.60000002 i\n1 0 0 -1
    -5.49998 70.500778 cm\n102.91186 37.10437 m\n72.758804 51.427067
    l\nS\nCM\n101.02499 35.112637 m\n96.768295 34.751328 l\n98.7668 34.039993
    l\n97.41188 33.396408 l\n98.7668 34.039993 l\n98.055466 32.041492
    l\nh\n101.02499 35.112637 m\nf\n1 0 0 -1 -5.49998 70.500778 cm\n106.52497
    35.388142 m\n102.26827 35.749451 l\n104.26678 36.460785 l\n102.91186
    37.10437 l\n104.26678 36.460785 l\n103.55544 38.459286 l\nh\n106.52497
    35.388142 m\nS\n0 i\n1 0 0 -1 89.083809 21.389088 cm\n-4 1.5
    m\n(\\()s\n0.60000002 i\n1 0 0 -1 -5.49998 70.500778 cm\n112.26776
    31.732235 m\n113.24408 32.708546 113.24408 34.291454 112.26776 35.267765
    c\n111.29146 36.24408 109.70854 36.24408 108.73224 35.267765 c\n107.75592
    34.291454 107.75592 32.708546 108.73224 31.732235 c\n109.70854 30.75592
    111.29146 30.75592 112.26776 31.732235 c\nS\n73 25.900002 m\n73 49
    l\nS\nCM\n67.500023 48.600777 m\n66.000023 44.600777 l\n67.500023
    46.100777 l\n67.500023 44.600777 l\n67.500023 46.100777 l\n69.000023
    44.600777 l\nh\n67.500023 48.600777 m\nf\n1 0 0 -1 -5.49998 70.500778
    cm\n73 21.900002 m\n71.5 25.900002 l\n73 24.400002 l\n73 25.900002 l\n73
    24.400002 l\n74.5 25.900002 l\nh\n73 21.900002 m\nS\n0 i\n1 0 0 -1
    72.954567 31.136074 cm\n-4 1.5 m\n(!)s\nep\nend\n%%Trailer\n%%EOF\n>|eps>||||||>
  </example>

  <paragraph|Graphes acycliques>

  Un graphe acyclique (sans-circuit) possde au moins un sommet sans
  prdcesseur, et au moins un sommet sans successeur. Un graphe est
  acyclique si et seulement si on peut attribuer  chaque sommet
  <with|mode|math|i> un nombre <with|mode|math|r(i)>, appel rang, tel que
  pour tout arc reliant <with|mode|math|i>  <with|mode|math|j> on ait
  <with|mode|math|r(i)> plus petit que <with|mode|math|r(j)>.

  <subparagraph|Algorithme du rang>

  Donne : un graphe orient acyclique

  <\enumerate-numeric>
    <item><with|mode|math|k=1>

    <item>On prend les sommets sans prdcesseurs : rang = k

    <item>On limine tous les sommets sans prdcesseurs

    <item><with|mode|math|k=k+1>; retour  2.
  </enumerate-numeric>

  Rsultat : le rang <with|mode|math|r(i)> minimal

  <subparagraph|Tri topologique>

  Donne : un graphe orient acyclique

  <\enumerate-numeric>
    <item><with|mode|math|k=1><strong|>

    <item>On prend un sommet <with|mode|math|i> sans prdcesseurs :
    <with|mode|math|\<nu\><rsub|i><rsub|>=k>

    <item>On retire le sommet du graphe

    <item><with|mode|math|k=k+1>; retour  2.
  </enumerate-numeric>

  Rsultat : une numrotation des sommets compatible avec le rang

  <subparagraph|Plus courts chemins dans les rseaux sans circuit>

  <\enumerate-numeric>
    <item>Tri topologique du graphe : sommet <with|mode|math|1\<ldots\>n>

    <item><with|mode|math|\<lambda\><rsub|i>=0> et pour
    <with|mode|math|k=1\<ldots\>n> on calcule
    <with|mode|math|\<lambda\><rsub|k>=min{\<lambda\><rsub|j>+c<rsub|j k> \|
    j\<in\>Pred(k)}>
  </enumerate-numeric>

  <subparagraph|Application  la gestion de projet>

  On considre un projet complexe (tches et ordre dfini), on cherche une
  planification optimale minimisant la dure totale.

  Le problme doit tre modlis par un rseau : les sommets reprsentent les
  tches, les arcs les contraintes de prcdence entre deux tches. Le poids
  de l'arc sortant quivaut  la dure de la tche. On ajoute des sommets
  <with|mode|math|\<alpha\>> (de dure nulle et sans prdcesseur)
  reprsentant le dbut des travaux, et <with|mode|math|\<omega\>> (de dure
  nulle et sans successeur) reprsentant la fin des travaux.

  On cherche maintenant le plus long chemin entre <with|mode|math|\<alpha\>>
  et <with|mode|math|\<omega\>>, on utilise pour ce faire l'algorithme du
  chemin critique.

  <page-break>

  <subparagraph|Algorithme du chemin critique>

  Donne : rseau tri topologiquement associ  un projet

  <\enumerate-numeric>
    <item>Rcurrence en avanant dans le projet

    <with|mode|math|\<delta\><rsub|i>=0>

    Pour <with|mode|math|k=2\<ldots\>n>, poser
    <with|mode|math|\<delta\><rsub|k>=max{\<delta\><rsub|j>+c<rsub|j
    k>\|j\<in\>Pred(k)}>

    <item>Rcurrence en reculant dans le projet

    <with|mode|math|D=\<delta\><rsub|n> et
    \<varphi\><rsub|n>=\<delta\><rsub|n>>

    Pour <with|mode|math|k=n-1\<ldots\>1>, poser
    <with|mode|math|\<varphi\><rsub|k>=min{\<varphi\><rsub|j>-c<rsub|k
    j>\|j\<in\>Succ(k)}>
  </enumerate-numeric>

  Rsultat : la dure minimale <with|mode|math|D> du projet et pour chaque
  tche <with|mode|math|i> sa date <with|mode|math|\<delta\><rsub|i>> de
  dbut au plus tt et sa date <with|mode|math|\<varphi\><rsub|i>> de dbut
  au plus tard.

  <\example>
    \;

    <tabular|<tformat|<twith|table-lborder|1px>|<twith|table-rborder|1px>|<twith|table-bborder|1px>|<twith|table-tborder|1px>|<cwith|1|7|1|9|cell-halign|c>|<cwith|1|7|1|1|cell-halign|l>|<cwith|1|7|1|9|cell-lborder|1px>|<cwith|7|7|9|9|cell-rborder|1px>|<cwith|7|7|9|9|cell-tborder|1px>|<cwith|1|7|1|9|cell-bborder|1px>|<twith|table-valign|b>|<table|<row|<cell|Tche>|<cell|<with|mode|math|\<alpha\>>>|<cell|A>|<cell|B>|<cell|C>|<cell|D>|<cell|E>|<cell|F>|<cell|<with|mode|math|\<omega\>><strong|>>>|<row|<cell|n<degreesign><with|mode|math|
    k>>|<cell|1>|<cell|2>|<cell|3>|<cell|4>|<cell|5>|<cell|6>|<cell|7>|<cell|8>>|<row|<cell|dure
    <with|mode|math|d<rsub|k>>>|<cell|0>|<cell|2>|<cell|4>|<cell|3>|<cell|2>|<cell|10>|<cell|4>|<cell|0>>|<row|<cell|<with|mode|math|Pred(k)>>|<cell|->|<cell|<with|mode|math|\<alpha\>>>|<cell|A>|<cell|B>|<cell|B>|<cell|C,D>|<cell|B>|<cell|E,F>>|<row|<cell|<with|mode|math|Succ(k)>>|<cell|A>|<cell|B>|<cell|C,D,F>|<cell|E>|<cell|E>|<cell|<with|mode|math|\<omega\>>>|<cell|<with|mode|math|\<omega\>>>|<cell|->>|<row|<cell|<with|mode|math|\<delta\><rsub|k>
    \<longrightarrow\>>>|<cell|0>|<cell|0>|<cell|2>|<cell|6>|<cell|6>|<cell|9>|<cell|6>|<cell|19>>|<row|<cell|<with|mode|math|\<varphi\><rsub|k>
    \<longleftarrow\>>>|<cell|0>|<cell|0>|<cell|2>|<cell|6>|<cell|7>|<cell|9>|<cell|15>|<cell|19>>>>><postscript|<tuple|<raw-data|%!PS-Adobe-3.0
    EPSF-3.0\n%%HiResBoundingBox: 0.000000 0.000000 266.997986
    85.003197\n%%Title: (Unknown)\n%%Creator: (Unknown)\n%%CreationDate:
    (Unknown)\n%%For: (Unknown)\n%%DocumentData: Clean7Bit\n%%LanguageLevel:
    2\n%%Pages: 1\n%%BoundingBox: 0 0 266
    85\n%%EndComments\n%%BeginProlog\n%%BeginFile: cg-pdf.ps\n%%Copyright:
    Copyright 2000-2002 Apple Computer Incorporated.\n%%Copyright: All Rights
    Reserved.\ncurrentpacking true setpacking\n/cg_md 100 dict def\ncg_md
    begin\n/L3? languagelevel 3 ge def\n/bd{bind def}bind def\n/ld{load
    def}bd\n/xs{exch store}bd\n/xd{exch def}bd\n/cmmtx matrix
    def\nmark\n/sc/setcolor\n/scs/setcolorspace\n/dr/defineresource\n/fr/findresource\n/T/true\n/F/false\n/d/setdash\n/w/setlinewidth\n/J/setlinecap\n/j/setlinejoin\n/M/setmiterlimit\n/i/setflat\n/rc/rectclip\n/rf/rectfill\n/rs/rectstroke\n/f/fill\n/f*/eofill\n/sf/selectfont\n/s/show\n/xS/xshow\n/yS/yshow\n/xyS/xyshow\n/S/stroke\n/m/moveto\n/l/lineto\n/c/curveto\n/h/closepath\n/n/newpath\n/q/gsave\n/Q/grestore\ncounttomark
    2 idiv\n{ld}repeat pop\nL3?{/csq/clipsave ld/csQ/cliprestore
    ld}if\n/SC{\t\n \ \ \ /ColorSpace fr scs\n}bd\n/cgmtx matrix
    def\n/sdmtx{cgmtx currentmatrix pop}bd\n/CM {cgmtx setmatrix}bd\t\t\n/cm
    {cmmtx astore CM concat}bd\t\n/W{clip newpath}bd\n/W*{eoclip
    newpath}bd\nstatusdict begin product end dup (HP) anchorsearch{\n
    \ \ \ pop pop pop\t\n \ \ \ true\n}{\n \ \ \ pop\t\n \ \ (hp)
    anchorsearch{\n\tpop pop true\n \ \ \ }{\n\tpop false\n
    \ \ \ }ifelse\n}ifelse\n{\t\n \ \ \ { \n\t{ \n\t \ \ \ pop pop \n\t
    \ \ \ (0)dup 0 4 -1 roll put\n\t \ \ \ F charpath\n\t}cshow\n
    \ \ \ }\n}{\n \ \ \ {F charpath}\n}ifelse\n/cply exch bd\n/cps {cply
    stroke}bd\n/pgsave 0 def\n/bp{/pgsave save store}bd\n/ep{pgsave restore
    showpage}def\t\t\n/re{4 2 roll m 1 index 0 rlineto 0 exch rlineto neg 0
    rlineto h}bd\n/scrdict 10 dict def\n/scrmtx matrix def\n/patarray 0
    def\n/createpat{patarray 3 1 roll put}bd\n/makepat{\nscrmtx astore
    pop\ngsave\ninitgraphics\nCM \npatarray exch
    get\nscrmtx\nmakepattern\ngrestore\nsetpattern\n}bd\n/cg_BeginEPSF{\n
    \ \ \ userdict save/cg_b4_Inc_state exch put\n
    \ \ \ userdict/cg_endepsf/cg_EndEPSF load put\n \ \ \ count
    userdict/cg_op_count 3 -1 roll put \n \ \ \ countdictstack dup array
    dictstack userdict/cg_dict_array 3 -1 roll put\n \ \ \ 3 sub{end}repeat\n
    \ \ \ /showpage {} def\n \ \ \ 0 setgray 0 setlinecap 1 setlinewidth 0
    setlinejoin\n \ \ \ 10 setmiterlimit [] 0 setdash newpath\n \ \ \ false
    setstrokeadjust false setoverprint\t\n}bd\n/cg_EndEPSF{\n
    \ countdictstack 3 sub { end } repeat\n \ cg_dict_array 3 1 index length
    3 sub getinterval\n \ {begin}forall\n \ count userdict/cg_op_count get
    sub{pop}repeat\n \ userdict/cg_b4_Inc_state get restore\n \ F
    setpacking\n}bd\n/cg_biproc{currentfile/RunLengthDecode
    filter}bd\n/cg_aiproc{currentfile/ASCII85Decode filter/RunLengthDecode
    filter}bd\n/ImageDataSource 0 def\nL3?\n{\n \ \ \ /cg_mibiproc{pop
    pop/ImageDataSource{cg_biproc}def}bd\n \ \ \ /cg_miaiproc{pop
    pop/ImageDataSource{cg_aiproc}def}bd\n}{\n \ \ \ /ImageBandMask 0 def\n
    \ \ \ /ImageBandData 0 def\n \ \ \ /cg_mibiproc{\n\tstring/ImageBandMask
    xs\n\tstring/ImageBandData xs\n\t/ImageDataSource{[currentfile/RunLengthDecode
    filter dup ImageBandMask/readstring cvx\n\t \ \ \ /pop cvx dup
    ImageBandData/readstring cvx/pop cvx]cvx bind}bd\n \ \ \ }bd\n
    \ \ \ /cg_miaiproc{\t\n\tstring/ImageBandMask xs\n\tstring/ImageBandData
    xs\n\t/ImageDataSource{[currentfile/ASCII85Decode filter/RunLengthDecode
    filter\n\t \ \ \ dup ImageBandMask/readstring cvx\n\t \ \ \ /pop cvx dup
    ImageBandData/readstring cvx/pop cvx]cvx bind}bd\n
    \ \ \ }bd\n}ifelse\n/imsave 0 def\n/BI{save/imsave xd mark}bd\n/EI{imsave
    restore}bd\n/ID{\ncounttomark 2 idiv\ndup 2 add\t\ndict begin\n{def}
    repeat\npop\t\t\n/ImageType 1 def\n/ImageMatrix[Width 0 0 Height neg 0
    Height]def\ncurrentdict dup/ImageMask known{ImageMask}{F}ifelse
    exch\nL3?{\n \ \ \ dup/MaskedImage known\n \ \ \ { \n\tpop\n\t\<\<\n\t
    \ \ \ /ImageType 3\n\t \ \ \ /InterleaveType 2\n\t \ \ \ /DataDict
    currentdict\n\t \ \ \ /MaskDict\n\t \ \ \ \<\< \ /ImageType 1\n\t\t/Width
    Width\n\t\t/Height Height\n\t\t/ImageMatrix
    ImageMatrix\n\t\t/BitsPerComponent 1\n\t\t/Decode [0
    1]\n\t\tcurrentdict/Interpolate known\n\t\t{/Interpolate
    Interpolate}if\n\t \ \ \ \>\>\n\t\>\>\n
    \ \ \ }if\n}if\nexch\n{imagemask}{image}ifelse\t\nend\t\n}bd\n/cguidfix{statusdict
    begin mark version end\n{cvr}stopped{cleartomark 0}{exch pop}ifelse\n2012
    lt{dup findfont dup length dict begin\n{1 index/FID ne 2 index/UniqueID
    ne and\n{def} {pop pop} ifelse}forall\ncurrentdict end definefont
    pop\n}{pop}ifelse\n}bd\n/t_array 0 def\n/t_i 0 def\n/t_c 1 string
    def\n/x_proc{ \n \ \ \ exch t_array t_i get add exch moveto\n \ \ \ /t_i
    t_i 1 add store\n}bd\n/y_proc{ \n \ \ \ t_array t_i get add moveto\n
    \ \ \ /t_i t_i 1 add store\n}bd\n/xy_proc{\n \ \ \ \ \ \ \ \n\tt_array
    t_i 2 copy 1 add get 3 1 roll get \n\t4 -1 roll add 3 1 roll add
    moveto\n\t/t_i t_i 2 add store\n}bd\n/sop 0 def\t\t\n/cp_proc/x_proc ld
    \t\n/base_charpath\t\t\n{\n \ \ \ /t_array xs\n \ \ \ /t_i 0 def\n
    \ \ \ { \n\tt_c 0 3 -1 roll put\n \ \ \ \ \ \ \ currentpoint\n\tt_c cply
    sop\n \ \ \ \ \ \ \ cp_proc\n \ \ \ }forall\n \ \ \ /t_array 0
    def\n}bd\n/sop/stroke ld\t\t\n/nop{}def\n/xsp/base_charpath
    ld\n/ysp{/cp_proc/y_proc ld base_charpath/cp_proc/x_proc
    ld}bd\n/xysp{/cp_proc/xy_proc ld base_charpath/cp_proc/x_proc
    ld}bd\n/xmp{/sop/nop ld /cp_proc/x_proc ld base_charpath/sop/stroke
    ld}bd\n/ymp{/sop/nop ld /cp_proc/y_proc ld base_charpath/sop/stroke
    ld}bd\n/xymp{/sop/nop ld /cp_proc/xy_proc ld base_charpath/sop/stroke
    ld}bd\n/refnt{ \nfindfont dup length dict copy dup\n/Encoding 4 -1 roll
    put \ndefinefont pop\n}bd\n/renmfont{ \nfindfont dup length dict copy
    definefont pop\n}bd\nend\nsetpacking\n%%EndFile\n%%EndProlog\n%%BeginSetup\n%%EndSetup\n%%Page:
    1 1\n%%PageBoundingBox: 0 0 266 85\n%%BeginPageSetup\ncg_md
    begin\nbp\nsdmtx\n%RBIBeginFontSubset:
    PWLNIP+Helvetica\n%!PS-TrueTypeFont-1.0000-0.0000-2\n
14 dict
    begin/FontName /PWLNIP+Helvetica def\n
/PaintType 0 def\n
/FontType 1
    def\n
/Encoding 256 array 0 1 255{1 index exch/.notdef put}for\n
dup 33
    /A put\n
dup 34 /B put\n
dup 35 /D put\n
dup 36 /F put\n
dup 37 /E
    put\n
dup 38 /C put\n
dup 39 /zero put\n
dup 40 /two put\n
dup 41 /four
    put\n
dup 42 /one put\n
dup 43 /three put\n
readonly def\n
/FontMatrix [
    0.00048828125 0 0 0.00048828125 0 0 ] def\n
/FontBBox{-342 -914 2036
    2100}def\n
/UniqueID 4069639 def\n
currentdict currentfile
    eexec\n
54544758EC884CF30C3CD503CEDBFF3839C47C3C3333173232E3FDBFF439491DB843E1924E63AA7726BBB0485AB56D93D8C0906F647A47162891E73FFC2A9873C4B1EAC5EEBDFFC4D06084FBD84139DF4583C6E259D10699944D1068C9C45667DCCCFB9B7EA01B606435EDCBD273ABAC093D14085CCBAC149BD7382E842CFE0D7FE4FD2EF589A2471F6074A80A8B675C2F7A50D63AC1EF90D787BADD11633CB01CF6EE3B37AAF9078A69AC4740E9B6525D78BBD839551A1CB80DB8682FA5E87591BBD6EE8B946063A2A58D9CA3685AB305495DC5FB5747EB8A9A059C4976C0FE4EEAB1D56FF47F1E9664ED9F4A7DAB763AF92B2F6CF2FA7DEC24710E0B9096E30F772BA7FEA9BDBE496C42ED2CEB58F54E80BDF57CE7B4DB6CCFE7182F43BF93CCA0767AF95D62C5D2C3DC6AE1E6D139F51A2C63432117F1714C5566572EE9967A715420ABDCD1D7BD74F8450B89965FCC81C6ACA565C5F3CCF91D430D1F953E4F1A645300A98DD8C47CD64555F08F422340A85404EAE0D3229C4F9336B9470CACBD6BBF3395104750A915CC6EAAC197668267B8C62D2764C8CD69FD937CA3C924D997A0EDE7964BEB9EA2F92EF70C5E5DA0AA5567765E71F2B911B3C5586B741EEB93F3C73016EC16BFF283758900903D203992EFC8BAFAF13579C602F38C91B64DFC330C1264D9E86DB21FFDE360EA73793134E310C3576495659FA8612BBF809CE248F446E82F1645EE5787AD39F29B4D6B88721E030F886A886484C4562DAC4B5020274225A81EA1DD7C77B05DD693D895D757705CB9BC227A22D11FCA199C0147D198A66AD2F178BD03023B697319EE31C1A3792C54E8F1290D44FC31EAA8B72891919C47C122B2F1E02E7714BB4B92DD94BDFE2C428DC8B34CDD7EA4E3B9D9A970A74E1B70ED9118485FA66D65A3B71E60036F0F168DBBD9EC05BEADE5777F97E18F81A1AA90B4AAE4471A85846E932BCC668898E40835B8EBC27F3F097497D4C925B78BA8B7C8B3DEC01E325052724F37BFFA22744F031B52DF7B39C885B2589639B3F0A59E8C4CA6AEB20BC0C259D12671C5728F9D6B520955D79FC47A6947E7C5635199498FBBE32385491B0D338C683EF3291DF174777D0B468B0697A1B2AA98A3A2768B08438F174F3B02D7C1EDB301F11FE53A2796178E5A0DE64B7E6B0F09419C5CEE6F526C3E0660F9C76318EC17AF209C76BC7884262F086E484E1B52FB070F036CAAF72B417E9C1FA83CB69834066089CB8F0CCD9DFEF63AD5CC7C16E2EE53D1DDD94AE4610A9F3825292888AC5BCB6AB49FD60EA464A9EAD4FE00BCD656CC52D6F8BB2A3909D2A97D37F59901D75576B9E92ADD40BCDDB8EAF3C5E024B570FB7F04C7579C9DA55ABB99CEBE4E45499CBF2C581D3C6A467C661C8B3445EC82C544DA02A54E1162104689832F40640939EDB0233AC7E933DE\n
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n
6F97CAB27E1CDE508B580979A139E3A4B6E41A7059BA3F8860A240CF581401137446E0890EF8831F947D0F877E0E8AE31F5B075B35F203BA4B5163B83A38B98EB3C7FCC48B9FD42AAD2587A977F7226CF9FD58EFFB0A717E43B3D57E820C141A7FEBD6DD14242B2AAF514C90664600\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
cleartomark
    end\n
\n%RBIEndFontSubset\n/PWLNIP+Helvetica
    cguidfix\n/F1.1/PWLNIP+Helvetica renmfont\n%RBIBeginFontSubset:
    BVFJQC+LucidaGrande\n%!PS-TrueTypeFont-1.0000-1.2000-2\n
14 dict
    begin/FontName /BVFJQC+LucidaGrande def\n
/PaintType 0 def\n
/FontType 1
    def\n
/Encoding 256 array 0 1 255{1 index exch/.notdef put}for\n
dup 33
    /alpha put\n
dup 34 /omega put\n
readonly def\n
/FontMatrix [
    0.00048828125 0 0 0.00048828125 0 0 ] def\n
/FontBBox{-1767 -1511 3361
    2462}def\n
/UniqueID 4223813 def\n
currentdict currentfile
    eexec\n
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n
12325C00DC7A5277EC59C2A84E759325040BF01671F5692BF641A1AC62E29BBEE6592FB8773E5F7E656A2AE710B8195258259691845EBEE80C2B7B8EB12D820A51DC4CDB5969E43ECC9F98E76B86F8F775892EE3EB9C8C866EB57A831E8F32BB629C39A755EFDAEDA58604B546E23CDF8099AF94E1FE5CAAC43FB1DB7BCBB405AA55B5B5AF0D59F376ED\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
0000000000000000000000000000000000000000000000000000000000000000\n
cleartomark
    end\n
\n%RBIEndFontSubset\n/BVFJQC+LucidaGrande
    cguidfix\n/F2.1/BVFJQC+LucidaGrande renmfont\n[ /CIEBasedA 5 dict dup
    begin /WhitePoint [ 0.9505 1.0000 1.0891 ] def \n/DecodeA { { 1.8008
    \ exp } bind \ exec} bind \ndef \n/MatrixA [ 0.9642 1.0000 0.8249 ] def
    \n/RangeLMN [ 0.0 2.0000 0.0 2.0000 0.0 2.0000 ] def \n/DecodeLMN [ {
    0.9857 \ mul} bind { 1.0000 \ mul} bind { 1.3202 \ mul} bind ] def \nend
    ] /Cs1 exch/ColorSpace dr pop\n%%EndPageSetup\n/Cs1 SC\n1 sc\nq\n0 0
    266.99799 85.003197 rc\n1 0 0 -1 -18 85.003197 cm\n18 -0.99680328 267
    86\nrf\n0.60000002 i\n0 sc\n1 0 0 -1 -17.5 84.503197 cm\n84.096191
    37.903812 m\n86.634605 40.442219 86.634605 44.557781 84.096191 47.096188
    c\n81.557785 49.634609 77.442215 49.634609 74.903809 47.096188
    c\n72.365395 44.557781 72.365395 40.442219 74.903809 37.903812
    c\n77.442215 35.365391 81.557785 35.365391 84.096191 37.903812 c\nS\n0
    i\n1 0 0 -1 62 42.003197 cm\n/F1.1[ 8 0 0 -8 0 0]sf\n-3.7000003 2
    m\n(!)s\n0.60000002 i\n1 0 0 -1 -17.5 84.503197 cm\n36.096188 37.903812
    m\n38.634609 40.442219 38.634609 44.557781 36.096188 47.096188
    c\n33.557781 49.634609 29.442217 49.634609 26.903811 47.096188
    c\n24.365391 44.557781 24.365391 40.442219 26.903811 37.903812
    c\n29.442217 35.365391 33.557781 35.365391 36.096188 37.903812 c\nS\n0
    i\n1 0 0 -1 14 42.003197 cm\n/F2.1[ 8 0 0 -8 0 0]sf\n-3.7000003 2
    m\n(!)s\n0.60000002 i\n1 0 0 -1 -17.5 84.503197 cm\n132.09619 37.903812
    m\n134.63461 40.442219 134.63461 44.557781 132.09619 47.096188
    c\n129.55779 49.634609 125.44221 49.634609 122.90381 47.096188
    c\n120.36539 44.557781 120.36539 40.442219 122.90381 37.903812
    c\n125.44221 35.365391 129.55779 35.365391 132.09619 37.903812 c\nS\n0
    i\n1 0 0 -1 110 42.003197 cm\n/F1.1[ 8 0 0 -8 0 0]sf\n-3.7000003 2
    m\n(")s\n0.60000002 i\n1 0 0 -1 -17.5 84.503197 cm\n180.09619 37.903812
    m\n182.63461 40.442219 182.63461 44.557781 180.09619 47.096188
    c\n177.55779 49.634609 173.44221 49.634609 170.90381 47.096188
    c\n168.36539 44.557781 168.36539 40.442219 170.90381 37.903812
    c\n173.44221 35.365391 177.55779 35.365391 180.09619 37.903812 c\nS\n0
    i\n1 0 0 -1 158 42.003197 cm\n-3.7000003 2 m\n(#)s\n0.60000002 i\n1 0 0
    -1 -17.5 84.503197 cm\n180.09619 66.903809 m\n182.63461 69.442215
    182.63461 73.557785 180.09619 76.096191 c\n177.55779 78.634605 173.44221
    78.634605 170.90381 76.096191 c\n168.36539 73.557785 168.36539 69.442215
    170.90381 66.903809 c\n173.44221 64.365395 177.55779 64.365395 180.09619
    66.903809 c\nS\n0 i\n1 0 0 -1 158 13.003197 cm\n-3.7000003 2
    m\n($)s\n0.60000002 i\n1 0 0 -1 -17.5 84.503197 cm\n228.09619 22.903809
    m\n230.63461 25.442215 230.63461 29.557785 228.09619 32.096188
    c\n225.55779 34.634609 221.44221 34.634609 218.90381 32.096188
    c\n216.36539 29.557785 216.36539 25.442215 218.90381 22.903809
    c\n221.44221 20.365395 225.55779 20.365395 228.09619 22.903809 c\nS\n0
    i\n1 0 0 -1 206 57.003197 cm\n-3.7000003 2 m\n(%)s\n0.60000002 i\n1 0 0
    -1 -17.5 84.503197 cm\n180.09619 8.9038086 m\n182.63461 11.442215
    182.63461 15.557785 180.09619 18.096191 c\n177.55779 20.634609 173.44221
    20.634609 170.90381 18.096191 c\n168.36539 15.557785 168.36539 11.442215
    170.90381 8.9038086 c\n173.44221 6.3653946 177.55779 6.3653946 180.09619
    8.9038086 c\nS\n0 i\n1 0 0 -1 158 71.003197 cm\n-3.7000003 2
    m\n(&)s\n0.60000002 i\n1 0 0 -1 -17.5 84.503197 cm\n276.09619 37.903812
    m\n278.63461 40.442219 278.63461 44.557781 276.09619 47.096188
    c\n273.55777 49.634609 269.44223 49.634609 266.90381 47.096188
    c\n264.36539 44.557781 264.36539 40.442219 266.90381 37.903812
    c\n269.44223 35.365391 273.55777 35.365391 276.09619 37.903812 c\nS\n0
    i\n1 0 0 -1 254 42.003197 cm\n/F2.1[ 8 0 0 -8 0 0]sf\n-4.7000003 2
    m\n(")s\n0.60000002 i\n1 0 0 -1 -17.5 84.503197 cm\n38.000004 42.5
    m\n67.099998 42.5 l\nS\nCM\n53.599998 42.003197 m\n49.599998 43.503197
    l\n51.099998 42.003197 l\n49.599998 42.003197 l\n51.099998 42.003197
    l\n49.599998 40.503197 l\nh\n53.599998 42.003197 m\nf\n1 0 0 -1 -17.5
    84.503197 cm\n71.099998 42.5 m\n67.099998 41 l\n68.599998 42.5
    l\n67.099998 42.5 l\n68.599998 42.5 l\n67.099998 44 l\nh\n71.099998 42.5
    m\nS\n0 i\n1 0 0 -1 36.5 43.821381 cm\n/F1.1[ 7 0 0 -7 0 0]sf\n-3 0.5
    m\n(')s\n0.60000002 i\n1 0 0 -1 -17.5 84.503197 cm\n86 42.500011 m\n115.1
    42.500004 l\nS\nCM\n101.6 42.003197 m\n97.599998 43.503197 l\n99.099998
    42.003197 l\n97.599998 42.003197 l\n99.099998 42.003197 l\n97.599998
    40.503197 l\nh\n101.6 42.003197 m\nf\n1 0 0 -1 -17.5 84.503197 cm\n119.1
    42.5 m\n115.1 41 l\n116.6 42.5 l\n115.1 42.5 l\n116.6 42.5 l\n115.1 44
    l\nh\n119.1 42.5 m\nS\n0 i\n1 0 0 -1 83.5 45.639553 cm\n-3 0.5
    m\n(\\()s\n0.60000002 i\n1 0 0 -1 -17.5 84.503197 cm\n134 42.5
    m\n163.10001 42.5 l\nS\nCM\n149.60001 42.003197 m\n145.60001 43.503197
    l\n147.10001 42.003197 l\n145.60001 42.003197 l\n147.10001 42.003197
    l\n145.60001 40.503197 l\nh\n149.60001 42.003197 m\nf\n1 0 0 -1 -17.5
    84.503197 cm\n167.10001 42.5 m\n163.10001 41 l\n164.60001 42.5
    l\n163.10001 42.5 l\n164.60001 42.5 l\n163.10001 44 l\nh\n167.10001 42.5
    m\nS\n0 i\n1 0 0 -1 134.86256 45.639561 cm\n-3 0.5 m\n(\\))s\n0.60000002
    i\n1 0 0 -1 -17.5 84.503197 cm\n133.06476 39.137962 m\n164.88535
    19.913025 l\nS\nCM\n150.80901 66.658638 m\n146.60966 65.874046
    l\n148.66922 65.365845 l\n147.38535 64.590172 l\n148.66922 65.365845
    l\n148.16101 63.306301 l\nh\n150.80901 66.658638 m\nf\n1 0 0 -1 -17.5
    84.503197 cm\n168.30901 17.844559 m\n164.10966 18.62915 l\n166.16922
    19.137352 l\n164.88535 19.913025 l\n166.16922 19.137352 l\n165.66101
    21.196896 l\nh\n168.30901 17.844559 m\nS\n0 i\n1 0 0 -1 131.67697
    59.348206 cm\n-3 0.5 m\n(\\))s\n0.60000002 i\n1 0 0 -1 -17.5 84.503197
    cm\n133.06476 45.862038 m\n164.88535 65.086975 l\nS\nCM\n150.80901
    17.347763 m\n148.16101 20.7001 l\n148.66922 18.640549 l\n147.38535
    19.416229 l\n148.66922 18.640549 l\n146.60966 18.132355 l\nh\n150.80901
    17.347763 m\nf\n1 0 0 -1 -17.5 84.503197 cm\n168.30901 67.155434
    m\n165.66101 63.803097 l\n166.16922 65.862648 l\n164.88535 65.086967
    l\n166.16922 65.862648 l\n164.10966 66.370842 l\nh\n168.30901 67.155434
    m\nS\n0 i\n1 0 0 -1 132.27826 22.170662 cm\n-3 0.5 m\n(\\))s\n0.60000002
    i\n1 0 0 -1 -17.5 84.503197 cm\n181.72351 69.61998 m\n259.62857 46.086166
    l\nS\nCM\n245.95767 39.573742 m\n241.69479 39.852947 l\n243.56448 38.8508
    l\n242.12857 38.417034 l\n243.56448 38.8508 l\n242.56235 36.981121
    l\nh\n245.95767 39.573742 m\nf\n1 0 0 -1 -17.5 84.503197 cm\n263.45767
    44.929455 m\n259.19479 44.650249 l\n261.06448 45.652397 l\n259.62857
    46.086163 l\n261.06448 45.652397 l\n260.06235 47.522076 l\nh\n263.45767
    44.929455 m\nS\n0 i\n1 0 0 -1 206.66096 22.004871 cm\n-3 0.5
    m\n(\\))s\n0.60000002 i\n1 0 0 -1 -17.5 84.503197 cm\n181.70538 40.560814
    m\n211.66318 31.199005 l\nS\nCM\n197.98111 54.497292 m\n193.71577
    54.735912 l\n195.59491 53.751602 l\n194.16319 53.304192 l\n195.59491
    53.751602 l\n194.6106 51.872471 l\nh\n197.98111 54.497292 m\nf\n1 0 0 -1
    -17.5 84.503197 cm\n215.48111 30.005905 m\n211.21577 29.767284
    l\n213.09491 30.751595 l\n211.66319 31.199005 l\n213.09491 30.751595
    l\n212.1106 32.630726 l\nh\n215.48111 30.005905 m\nS\n0 i\n1 0 0 -1
    181.69101 43.691963 cm\n-3 0.5 m\n(\\()s\n0.60000002 i\n1 0 0 -1 -17.5
    84.503197 cm\n229.70538 29.439186 m\n259.66318 38.800995
    l\nS\nCM\n245.98111 44.509102 m\n242.6106 47.133923 l\n243.59491
    45.254787 l\n242.16318 45.702202 l\n243.59491 45.254787 l\n241.71579
    44.270481 l\nh\n245.98111 44.509102 m\nf\n1 0 0 -1 -17.5 84.503197
    cm\n263.48111 39.994095 m\n260.1106 37.369274 l\n261.09491 39.248409
    l\n259.66318 38.800995 l\n261.09491 39.248409 l\n259.21579 40.232716
    l\nh\n263.48111 39.994095 m\nS\n0 i\n1 0 0 -1 227.61133 54.059441 cm\n-5
    0.5 m\n(*')[ 3.893066 3.893066 ] xS\n0.60000002 i\n1 0 0 -1 -17.5
    84.503197 cm\n181.74117 15.320351 m\n211.59483 24.027664
    l\nS\nCM\n197.93483 59.355534 m\n194.51483 61.915535 l\n195.53484
    60.055534 l\n194.09483 60.475533 l\n195.53484 60.055534 l\n193.67484
    59.03553 l\nh\n197.93483 59.355534 m\nf\n1 0 0 -1 -17.5 84.503197
    cm\n215.43483 25.147663 m\n212.01483 22.587662 l\n213.03484 24.447662
    l\n211.59483 24.027664 l\n213.03484 24.447662 l\n211.17484 25.467667
    l\nh\n215.43483 25.147663 m\nS\n0 i\n1 0 0 -1 181.86246 67.831184 cm\n-3
    0.5 m\n(+)s\nep\nend\n%%Trailer\n%%EOF\n>|eps>||||||>

    <\itemize-minus>
      <item>la tche est critique si <with|mode|math|\<delta\><rsub|i>=\<varphi\><rsub|i>>
      un retard dans la tche implique un retard du projet

      <item>un chemin critique va de <with|mode|math|\<alpha\>> 
      <with|mode|math|\<omega\>> en passant uniquement par des tches
      critiques

      <item>la longueur du chemin critique est la dure minimale du projet
    </itemize-minus>
  </example>

  <subsection|Problme du transbordement>

  <subsubsection|Dfinition>s

  <\itemize-minus>
    <item>Soit un graphe orient connexe <with|mode|math|G=(V,E)>. Soit
    <with|mode|math|b \ >une pondration des sommets reprsentant les offres
    et les demandes : offre (sommet source) =\<gtr\> <with|mode|math|-> et
    demande (sommet puits) =\<gtr\> <with|mode|math|+>. Soit
    <with|mode|math|c> une pondration des arcs reprsentant les cots
    unitaires d'utilisation des arcs.

    La solution basique linaire du problmes est l'arbre maximal du rseau.

    <item>Un graphe <with|mode|math|G=(V,E)> est biparti s'il existe une
    partition de ses sommes en deux ensembles <with|mode|math|V<rsub|1>> et
    <with|mode|math|V<rsub|2>> telle que toute arte <with|mode|math|(i,j)>
    de <with|mode|math|E> ait une extrmit dans <with|mode|math|V<rsub|1>>
    et l'autre dans <with|mode|math|V<rsub|2>>.

    <item>Lorsque <with|mode|math|G> est un graphe biparti complet, chaque
    sommet source tant reli  tous les sommets puits, on parle de problme
    de transport.

    <item>Si, dans un problme de transport, il y a autant de sommets source
    que de sommets puits et que toutes les offres et les demandes sont gales
     1, on parle de problme d'affectation.\ 
  </itemize-minus>

  <subsubsection|Algorithme>

  <strong|Donne:> un rseau connexe <with|mode|math|R(V,E,b,c)>\ 

  <\enumerate-numeric>
    <item>Construction du problme auxiliaire et de sa solution initiale
    admissible

    <item>Rsolution du problme auxiliaire  l'aide de l'algorithme
    graphique du Simplexe

    <item>Les arcs, et seulement les arcs (les pondrations restent
    inchanges), de la solution optimale du problme auxiliaire forment la
    solution-arbre admissible pour le problme initial

    <item>Rsolution du problme initial  l'aide de l'algorithme graphique
    du Simplexe
  </enumerate-numeric>

  <\with|par-left|0.6cm>
    <\with|par-left|0>
      <strong|Rsultat:> solution optimale pour le rseau\ 
    </with>
  </with>

  <page-break>

  <subsubsection|L'algorithme graphique du Simplexe dans les rseaux>

  <strong|Donne:> rseau connexe avec une solution-arbre admissible
  <with|mode|math|T>

  <\enumerate-numeric>
    <item>Calcul des solutions primale <with|mode|math|x> et duale
    <with|mode|math|y> associes  <with|mode|math|T>

    <item>Recherche d'un arc entrant, s'il n'en existe pas =\<gtr\> STOP :
    solution optimale

    <item>Recherche d'un arc sortant, s'il n'en existe pas =\<gtr\> STOP :
    pas d'optimum fini

    <item>Mise  jour de la solution-arbre et retour  1.
  </enumerate-numeric>

  <strong|Rsultat> : un flot de cot total minimum ou la preuve qu'un tel
  flot n'existe pas\ 

  <subsubsection|Construction du problme auxiliaire et de sa solution
  initiale admissible>

  <strong|Donne:> un rseau <with|mode|math|R=(V,E,b,c)> connexe

  <\enumerate-numeric>
    <item>Poser <with|mode|math|c<rsub|i j><rprime|'>=0 \ \ \<forall\>(i,
    j)\<in\>E >

    <item>Choisir un sommet source <with|mode|math|k>.

    <item>Relier chaque sommet source <with|mode|math|i(\<neq\>k)> 
    <with|mode|math|k> par un arc artificiel <with|mode|math|(i,k)> de poids
    <with|mode|math|c<rsub|i k><rprime|'>=1> (s'il existe dj un arc de
    <with|mode|math|i>  <with|mode|math|k> dans <with|mode|math|R>, ne pas
    le rajouter)

    <item>Relier <with|mode|math|k>  chaque sommet puits <with|mode|math|j>
    par un arc artificiel <with|mode|math|(k,j)> de poids
    <with|mode|math|c<rsub|k j><rprime|'>=1> (s'il existe dj un arc de
    <with|mode|math|k>  <with|mode|math|j> dans <with|mode|math|R>, ne pas
    le rajouter)

    <item>Poser <with|mode|math|E<rprime|'><rsub|T>={(i,k)\|i sommet
    source}\<cup\>{(k,j)\|j sommet puits}> et complter
    <with|mode|math|E<rprime|'><rsub|T>> jusqu' obtenir un arbre maximal (si
    ncessaire).
  </enumerate-numeric>

  <strong|Rsultat:> un rseau <with|mode|math|R<rprime|'>=(V,E<rprime|'>,b,c)>
  et une solution-arbre <with|mode|math|T<rprime|'>=(V,E<rsub|T><rprime|'>)>
  admissible pour <with|mode|math|R<rprime|'>>

  <subsubsection|Calcul de la solution primale <with|mode|math|x> associe 
  <with|mode|math|T=(V,E<rsub|T>)>>

  <strong|Donne:> rseau <with|mode|math|R=(V,E,b,c)> connexe et une
  solution-arbre <with|mode|math|T>

  <\enumerate-numeric>
    <item>Tant que <with|mode|math|<mid|\|>E<rsub|T><mid|\|>\<gtr\>1 faire>

    <\enumerate-alpha>
      <item>Trouver un sommet pendant <with|mode|math|j> de
      <with|mode|math|T>. Soit <with|mode|math|e> le seul arc incident avec
      <with|mode|math|j> dans <with|mode|math|T> et <with|mode|math|i>
      l'autre extrmit de <with|mode|math|e.>

      <item>Si <with|mode|math|e=(i,j)> poser <with|mode|math|x<rsub|i
      j>=b<rsub|j>>, sinon poser <with|mode|math|x<rsub|j i> = -b<rsub|j>>

      <item>Poser <with|mode|math|b<rsub|i>=b<rsub|i>+b<rsub|j>>

      <item>Retirer <with|mode|math|e> de <with|mode|math|E<rsub|T>>
    </enumerate-alpha>

    <item>Il reste un seul arc dans <with|mode|math|E<rsub|T>>, disons
    (<with|mode|math|i>,<with|mode|math|j>), poser <with|mode|math|x<rsub|i
    j>=b<rsub|j>>
  </enumerate-numeric>

  Rsultat : le flot <with|mode|math|x:E\<longrightarrow\>\<bbb-R\><rsub|+>>
  associ  <with|mode|math|T> et <with|mode|math|z=<big|sum>c<rsub|i
  j>x<rsub|i j>>

  <subsubsection|Calcul de la solution duale <with|mode|math|y> associe 
  <with|mode|math|T=(V, E<rsub|T>)>>

  Donnes : rseau <with|mode|math|R=(V,E,b,c)> connexe et une solution-arbre
  <with|mode|math|T>

  <\enumerate-numeric>
    <item>Choisir arbitrairement <with|mode|math|i\<in\>V>, poser
    <with|mode|math|y<rsub|i>=0> et poser
    <with|mode|math|W=V\<backslash\>{i}>

    <item>Tant que <with|mode|math|W\<neq\>\<varnothing\>> faire

    <\enumerate-alpha>
      <item>Trouver un arc <with|mode|math|e\<in\>E<rsub|T>> avec une
      extrmit <with|mode|math|j > dans <with|mode|math|W> et une extrmit
      <with|mode|math|i> dans <with|mode|math|<wide|W|\<bar\>>=V\<backslash\>W
      >

      <item>Si <with|mode|math|e=(i,j)> poser
      <with|mode|math|y<rsub|j>=y<rsub|i>+c<rsub|i j>> sinon
      <with|mode|math|y<rsub|j>=y<rsub|i>-c<rsub|i j>><item>Retirer
      <with|mode|math|j> de <with|mode|math|W> \ \ 
    </enumerate-alpha>
  </enumerate-numeric>

  Rsultats : les prix duaux <with|mode|math|y :V\<longrightarrow\>\<bbb-R\>>
  associs  <with|mode|math|T> et <with|mode|math|w=<big|sum>b<rsub|i>*y<rsub|i>>

  <subsubsection|Recherche d'un arc entrant>

  Donne : solution-arbre admissible <with|mode|math|T=(V,E<rsub|T>)> ainsi
  que les solutions <with|mode|math|x> et <with|mode|math|y> associes.

  <\enumerate-numeric>
    <item>On passe en revue les arcs <with|mode|math|(i,j)\<nin\>E<rsub|T>>
    (hors base) et on teste pour chacun d'eux si la contrainte duale associe
    <with|mode|math|y<rsub|j>-y<rsub|i>\<leq\>c<rsub|i j>> est satisfaite ou
    non.

    <item>Ds qu'une contrainte viole est trouve : STOP, l'arc
    <with|mode|math|e=(i,j)> en question rentre dans la base.

    <item>Si toutes les contraintes sont satisfaites, les solutions actuelles
    sont optimales.
  </enumerate-numeric>

  <page-break>

  <subsubsection|Recherche d'un arc sortant>

  Si on ajoute  la solution-arbre actuelle l'arc entrant
  <with|mode|math|e=(i,j)>, on forme un cycle unique <with|mode|math|C>.
  Utilisant l'orientation de <with|mode|math|(i,j)> pour dfinir le sens de
  parcours de <with|mode|math|C>, on divise les arcs de <with|mode|math|C> en
  deux ensembles disjoints <with|mode|math|C<rsup|+>> (mme orientation que
  <with|mode|math|(i,j)>) et <with|mode|math|C<rsup|->>.

  <\enumerate-numeric>
    <item>Si <with|mode|math|C<rsup|->=\<varnothing\>>: STOP, pas d'optimum
    fini

    <item>Sinon, soit <with|mode|math|\<Delta\>=min{x<rsub|k
    l>\|(k,l)\<in\>C<rsup|->}> et <with|mode|math|s> un arc pour lequel le
    minimum est atteint. L'arc <with|mode|math|s> quitte la base.\ 
  </enumerate-numeric>

  <subsubsection|Mise  jour des solutions>

  <\enumerate-numeric>
    <item>La nouvelle solution-arbre est donnes par
    <with|mode|math|E<rsub|T>=E<rsub|T>\<cup\>{e}\<backslash\>{s}>

    <item>La solution basique primale ne change que sur les arcs de
    <with|mode|math|C> :

    <\equation*>
      x<rsub|i j>=<choice|<tformat|<table|<row|<cell|x<rsub|i
      j>+\<Delta\><htab|5mm>si (i,j)\<in\>C<rsup|+>>>|<row|<cell|x<rsub|i
      j>-\<Delta\><htab|5mm>si (i,j)\<in\>C<rsup|->>>|<row|<cell|x<rsub|i j>
      \ \ \ \ <htab|5mm><htab|5mm>si (i,j)\<nin\>C>>>>>
    </equation*>

    <item>La solution basique duale ne change que de la manire suivante.

    <\equation*>
      y<rsub|d>=y<rsub|d>+\<varepsilon\>
    </equation*>

    o <with|mode|math|d> est le sommet commun entre les arcs
    <with|mode|math|e> et <with|mode|math|s>, et\ 

    <\equation*>
      \<varepsilon\>=<choice|<tformat|<table|<row|<cell|-y<rsub|d>+y<rsub|a>+c<rsub|a
      d>>|<cell|si e=(a,d) et s=(b,d)>>|<row|<cell|y<rsub|a>-y<rsub|d>-c<rsub|d
      a>>|<cell|si e=(d,a) et s=(d,b)>>>>>
    </equation*>
  </enumerate-numeric>

  <subsubsection|Dgnrescence>

  Si la solution basique primale est dgnr, c--d s'il existe des arcs
  dans <with|mode|math|E<rsub|T>> le long desquels des quantits nulles sont
  transportes, il y a risque de cyclage. Pour viter cela, recourons  la
  rgle de Bland graphique :

  <\itemize-dot>
    <item>Tester les arcs dans l'ordre lexicographique et faire entrer le
    premier arc dont la contrainte duale associe est viole.

    <item>Si la quantit <with|mode|math|\<Delta\>> est transporte le long
    de plusieurs arcs de <with|mode|math|C<rsup|->>, faire sortir l'arc le
    plus petit dans l'ordre lexicographique.\ 
  </itemize-dot>

  <section|Chanes de Markov>

  <subsection|Dfinitions>

  <\itemize-minus>
    <item>Un processus stochastique est une collection de variables
    alatoires <with|mode|math|{X<rsub|t>, \ t\<in\>T}> avec
    <with|mode|math|X<rsub|t>=>tat du processus au temps <with|mode|math|t>
    (<with|mode|math|X<rsub|t>\<in\>S>).

    <item>Un processus stochastique dont l'ensemble des tats
    <with|mode|math|S> est fini ou dnombrable est appel une chane.

    <item>Un processus est  temps continu lorsque l'ensemble
    <with|mode|math|T> est non dnombrable :
    <with|mode|math|T=\<bbb-R\><rsub|+>>

    <item>Un processus est  temps discret lorsque l'ensemble
    <with|mode|math|T> est fini ou dnombrable :
    <with|mode|math|T=\<bbb-Z\><rsub|+>>

    <item>Un processus est markovien si, pour tout instant
    <with|mode|math|t>, l'tat courant <with|mode|math|X<rsub|t>> rsume, 
    lui seul, tout l'historique du systme susceptible d'influencer son
    volution future.

    <item>Une volution du systme est appele trajectoire.
  </itemize-minus>

  <subsection|Chanes de Markov  temps discret>

  <subsubsection|Matrice de transition>

  La matrice de transition <with|mode|math|P> peut tre reprsent par un
  graphe reprsentatif <with|mode|math|G>.\ 

  <with|mode|math|P> est stochastique <with|mode|math|\<Leftrightarrow\>><with|mode|math|p<rsub|i
  j>\<geq\>0 \ \ \ \ \ \<forall\>i j \ ; <big|sum><rsub|j>p<rsub|i j>=1
  \ \ \<forall\>i>

  <strong|Probabilit de transition> de <with|mode|math|i> 
  <with|mode|math|j> en <with|mode|math|m> tapes est donne par l'lment
  <with|mode|math|i j> de la matrice <with|mode|math|P> leve  la puissance
  <with|mode|math|m> : <with|mode|math|(P<rsup|m>)<rsub|i j>> avec
  <with|mode|math|P<rsup|0>=I et P<rsup|1>=P>.

  <page-break>

  <subsubsection|Classification>

  <\enumerate-numeric>
    <item>Dterminer les classes en calculant les composantes fortement
    connexes du graphe <with|mode|math|G> de la chane.

    <item>Construire le graphe rduit <with|mode|math|G<rsub|R>> formes des
    classes de <with|mode|math|G> et en dduire la classification des classes
    et des tats.

    Une <strong|classe> est:

    <\itemize-minus>
      <item><strong|persistante> si elle n'a pas de sommet successeur

      <item><strong|transitoire> si elle a au moins un sommet successeur

      <item><strong|absorbante> si elle est persistante et compose d'un seul
      tat
    </itemize-minus>

    Un <strong|tat> est:

    <\itemize-minus>
      <item><strong|persistant> s'il appartient  une classe persistante

      <item><strong|transitoire> s'il appartient  une classe transitoire

      <item><strong|absorbant> s'il appartient  une classe absorbante
      (<with|mode|math|p<rsub|i i>=1) >
    </itemize-minus>

    <item><strong|Classifier la chane> :\ 

    <\itemize-minus>
      <item>Elle est <strong|irrductible> si elle n'a qu'une seule classe,
      sinon elle est rductible

      <item>Elle est <strong|absorbante> si tous ses tats persistants sont
      absorbants

      <item>Elle est <strong|ergodique> si elle est irrductible et
      apriodique
    </itemize-minus>
  </enumerate-numeric>

  <subsubsection|tude des classes persistantes>

  Pour chaque classe persistante

  <\enumerate-numeric>
    <item>Dterminer sa <strong|priode><strong|> :

    La priode est le plus grand commun diviseur des longueurs du circuit (nb
    d'arcs)

    La priode <with|mode|math|d\<gtr\>1> =\<gtr\> la classe est de priode
    <with|mode|math|d>. Si <with|mode|math|d=1> la classe est apriodique

    <item>Calculer sa <strong|distribution stationnaire >:\ 

    <\equation*>
      <wide|\<pi\>|\<vect\>>=<matrix|<tformat|<table|<row|<cell|\<pi\><rsub|1>>|<cell|\<ldots\>>|<cell|\<pi\><rsub|n>>>>>><htab|5mm><choice|<tformat|<table|<row|<cell|<wide|\<pi\>|\<vect\>><rsup|>P=<wide|\<pi\>|\<vect\>>>>|<row|<cell|<wide|\<pi\>|\<vect\>><wide|1|\<vect\>>=1>>>>>
    </equation*>

    <with|mode|math|P> est ici la matrice de transition de la chane o les
    composantes qui ne se rapportent pas  la classe ont t annules.

    Cette distribution est unique si la chane est ergodique.
  </enumerate-numeric>

  <subsubsection|tude des tats transitoires>

  <\enumerate-numeric>
    <item>Contracter les classes persistantes afin d'obtenir une chane
    absorbante (facultatif)

    <item>Mettre la matrice de transition de la chane sous <strong|forme
    canonique>:

    Rordonner les sommets dans la matrice :

    <\itemize-minus>
      <item>les sommets persistants sont numrots en premier.

      <item>les sommets d'une classe sont numrots conscutivement.
    </itemize-minus>

    Si la chane  <with|mode|math|k> classe persistante, la matrice sous
    forme canonique  la forme suivante :

    <\equation*>
      P<rprime|'>=<matrix|<tformat|<cwith|4|4|1|4|cell-tborder|1px>|<cwith|1|4|4|4|cell-lborder|1px>|<table|<row|<cell|P<rsub|1>>|<cell|>|<cell|0>|<cell|0>>|<row|<cell|>|<cell|\<ddots\>>|<cell|>|<cell|\<vdots\>>>|<row|<cell|0>|<cell|>|<cell|P<rsub|k>>|<cell|0>>|<row|<cell|R<rsub|1>>|<cell|\<cdots\>>|<cell|R<rsub|k>>|<cell|Q>>>>><with|mode|text|si
      la chane est absorbante : >P<rprime|'>=<matrix|<tformat|<cwith|2|2|1|2|cell-tborder|1px>|<cwith|1|2|2|2|cell-lborder|1px>|<table|<row|<cell|I>|<cell|0>>|<row|<cell|R>|<cell|Q>>>>>
    </equation*>

    <item>Calculer la <strong|matrice fondamentale>
    <with|mode|math|N=(I-Q)<rsup|-1>> et la <strong|matrice des probabilits
    d'absorption> <with|mode|math|B= N R >.
  </enumerate-numeric>

  <page-break>

  <subsubsection|Interprtation>

  <\itemize-minus>
    <item>La probabilit d'tre dans l'tat <with|mode|math|i> est donne par
    <with|mode|math|\<pi\><rsub|i>>.

    <item>Le nombre moyen de transitions entre 2 visites successives de
    l'tat <with|mode|math|i> est donn par
    <with|mode|math|<frac|1|\<pi\><rsub|i>>>.

    <item>Le nombre moyen de priodes sjourn dans l'tat transitoire
    <with|mode|math|j> partant de l'tat transitoire <with|mode|math|i>,
    avant absorption, est l'lment <with|mode|math|n<rsub|i j>> de la
    matrice N.

    <item>Le nombre moyen de transitions avant d'atteindre un tat absorbant
    en partant de l'tat transitoire <with|mode|math|i> est la somme des
    lments de la <with|mode|math|i<rsup|e>> ligne de <with|mode|math|N.>

    <item>La probabilit d'tre absorb par l'tat <with|mode|math|j> en
    partant de l'tat transitoire <with|mode|math|i> est donne par l'lment
    <with|mode|math|b<rsub|i j>> de la matrice de <with|mode|math|B>.
  </itemize-minus>

  <subsection|Chanes de Markov  temps continu>

  <subsubsection|Probabilits et matrices de transition>

  Les probabilits de transition au temps <with|mode|math|t> :

  <\equation*>
    p<rsub|i j>(t)=P[X<rsub|t>=j\|X<rsub|0>=i]
  </equation*>

  La matrice de transition au temps <with|mode|math|t> :

  <\equation*>
    P(t)=(p<rsub|i j>(t))
  </equation*>

  On suppose toujours <with|mode|math|P(0)=I>

  <subsubsection|Classification>

  La classification est la mme que pour une chane de Markov  temps discret
  augmente des dfinitions suivantes.

  <paragraph|Classe et tat>

  Dans les chanes  temps continu, les classes et tats persistants sont
  appels <strong|rcurrents>.

  <paragraph|Chane>

  Elle est <strong|rgulire> ssi le nombre de transition qu'elle effectue
  dans un intervalle de temps fini est fini. Toute chane ayant un nombre
  fini d'tat est rgulire.

  Une chane est irrductible si tous ses tats communiquent deux  deux.

  Une chane ergodique est aussi appele <strong|rcurrente non nulle>.

  <subsubsection|Structure>

  <\itemize-dot>
    <item>Le temps de sjour <with|mode|math|\<tau\><rsub|i>> dans un tat
    <with|mode|math|i> est une variable alatoire exponentielle de paramtre
    <with|mode|math|\<lambda\><rsub|i>> ne dpendant que de
    <with|mode|math|i>.

    <item> La probabilit de passage quittant l'tat <with|mode|math|i> pour
    aller en <with|mode|math|j>, note <with|mode|math|q<rsub|i j>> est
    indpendante de <with|mode|math|t> et de
    <with|mode|math|\<tau\><rsub|i>>.

    <item>La suite des tats visits par un chane de Markov  temps continu
    forme une chane de Markov  temps discret, appele chane induite ou
    sous-jacente et donne par sa matrice de transition
    <with|mode|math|Q=q<rsub|i j>> avec <with|mode|math|q<rsub|i i>=0>.
  </itemize-dot>

  <subsubsection|Loi exponentielle>

  La loi exponentielle est la seule loi continue sans mmoire.

  Soit <with|mode|math|X> une variable alatoire exponentielle de paramtre
  <with|mode|math|\<lambda\>> (<with|mode|math|\<lambda\>\<gtr\>0>) :

  <\equation*>
    P\|X\<leq\>x\| =F(x)=<choice|<tformat|<table|<row|<cell|1-e<rsup|-\<lambda\>
    x><htab|5mm>x\<geq\>0>>|<row|<cell|0<htab|5mm><htab|5mm><htab|5mm>
    \ \ \ x\<less\>0>>>>>
  </equation*>

  La <strong|densit> de <with|mode|math|X> est
  <with|mode|math|f(x)=<choice|<tformat|<table|<row|<cell|\<lambda\>e<rsup|-\<lambda\>x><htab|5mm>x\<geq\>0>>|<row|<cell|0<htab|5mm><htab|5mm>
  \ \ \ \ \ x\<less\>0>>>>>>

  L'<strong|esprance> de <with|mode|math|X> est
  <with|mode|math|E[X]=<frac|1|\<lambda\>>> et sa <strong|variance>
  <with|mode|math|Var[X]=<frac|1|\<lambda\><rsup|2>>>\ 

  <with|mode|math|i> est un tat absorbant ssi <with|mode|math|i> est une
  variable alatoire exponentielle de paramtre
  <with|mode|math|\<lambda\><rsub|i>> = 0. Si ce paramtre gal  l'infini
  alors la variable ne prend qu'une valeur: 0, c'est un tat dont on sort
  tout de suite

  <with|mode|math|P\|X\<leq\>x\|> donne la <strong|probabilit de sortir de
  l'tat> pour <with|mode|math|t\<leq\>x>, et <with|mode|math|E[X]> donne le
  <strong|temps moyen de sjour>

  <subsubsection|Matrice gnratrice>

  Soit la matrice A (matrice d'intensit):

  <\equation*>
    a<rsub|i j>=<choice|<tformat|<table|<row|<cell|-\<lambda\><rsub|i><htab|5mm>si
    i=j<htab|5mm>(<with|mode|text|intensit de passage hors de>
    \ i)>>|<row|<cell|\<lambda\><rsub|i> q<rsub|i j> \ \ \ \ \ \ \ \ \ \ si
    i\<neq\>j<htab|5mm>(<with|mode|text|intensit de transition de> i
    <with|mode|text|> j)>>>>>
  </equation*>

  avec <with|mode|math|a<rsub|i j>\<gtr\>0 \ si i\<neq\>j \ et
  <big|sum><rsub|j>a<rsub|i j>=0 \ \ \ \ \<longrightarrow\>> graphe
  reprsentatif de A

  <subsubsection|Matrice de transition de la chane sous-jacente>

  Le matrice de transition <with|mode|math|Q> de la chane de Markov  temps
  discret sous-jacente peut tre retrouve  l'aide de la matrice gnratrice
   l'aide des rgles suivantes:

  <\equation*>
    q<rsub|i j>=<left|{><tabular|<tformat|<table|<row|<cell|-<frac|a<rsub|i
    j>|a<rsub|i i>>>|<cell|si a<rsub|i i>\<less\>0 et j
    \<neq\>i>>|<row|<cell|0>|<cell|si a<rsub|i i>=0 \ et
    j\<neq\>i>>|<row|<cell|0>|<cell|si a<rsub|i i>\<less\>0 et
    j=i>>|<row|<cell|1>|<cell|si a<rsub|i i>=0 et j=i>>>>>
  </equation*>

  <subsubsection|quations de Kolmogorov>

  <\itemize-minus>
    <item>quation du futur : <with|mode|math|P<rprime|'>(t)=A P(t)>

    <item>quation du pass : <with|mode|math|P<rprime|'>(t) = P(t) A>
  </itemize-minus>

  <subsubsection|Distribution>

  Distribution initiale : <with|mode|math|<wide|\<pi\>|\<vect\>>(0)>

  Probabilit d'observer le processus dans l'tat <with|mode|math|i> au temps
  <with|mode|math|t> : <with|mode|math|<wide|\<pi\>|\<vect\>>(t)=<wide|\<pi\>|\<vect\>>(0)P(t)>

  Distribution stationnaire :

  <\equation*>
    <choice|<tformat|<table|<row|<cell|<wide|\<pi\>|\<vect\>><rsup|T>A=<wide|0|\<vect\>><rsup|T>>>|<row|<cell|<wide|\<pi\>|\<vect\>><wide|1|\<vect\>>=1>>>>>
  </equation*>

  Ce systme a une solution unique si la chane est ergodique (rcurrente non
  nulle).

  \;

  Taux de transition hors de l'tat <with|mode|math|i> :
  <with|mode|math|\<pi\><rsub|i> a<rsub|i i>>

  Taux de transition dans l'tat <with|mode|math|i> :
  <with|mode|math|<big|sum><rsub|j i>\<pi\><rsub|j> a<rsub|i i>>

  Proportion de temps pass dans l'tat <with|mode|math|i> :
  <with|mode|math|\<pi\><rsub|i>>

  Esprance du temps entre deux visites <with|mode|math|<frac|1|\<pi\><rsub|i>\<alpha\><rsub|i>>>

  <subsubsection|Processus de naissance et de mort>

  Depuis <with|mode|math|i>, les transitions se font que vers
  <with|mode|math|i-1> (mort) ou <with|mode|math|i+1> (naissance).

  Taux de naissance : <with|mode|math|\<lambda\><rsub|i>>

  Taux de mort : <with|mode|math|\<mu\><rsub|i>>

  Le processus reste dans l'tat <with|mode|math|i> pendant une dure
  alatoire exponentielle de paramtre <with|mode|math|\<alpha\><rsub|i>=\<lambda\><rsub|i>+\<mu\><rsub|i>>.

  Lorsqu'il quitte l'tat <with|mode|math|i>, il se retrouve dans l'tat
  <with|mode|math|i-1> ou <with|mode|math|i+1> avec une probabilit

  <\equation*>
    q<rsub|i, i-1>=<frac|\<mu\><rsub|i>|\<lambda\><rsub|i>+\<mu\><rsub|i>><htab|5mm>q<rsub|i,i+1>=<frac|\<lambda\><rsub|i>|\<lambda\><rsub|i>+\<mu\><rsub|i>>
  </equation*>

  <paragraph|Processus de Poisson>

  C'est un processus de naissance pur  taux constant :
  <with|mode|math|\<lambda\><rsub|i>=\<lambda\>> et
  <with|mode|math|\<mu\><rsub|i>=0 \ \ \ \ \ \ \<forall\>i>.

  <subsubsection|Files d'attentes>

  <paragraph|Ajouts>

  <\itemize-minus>
    <item>Le temps moyen d'excution d'une tche rgie par une variable
    alatoire est l'esprance de cette dernire.

    <item>Dans M/G/1 : <with|mode|math|C<rsup|2><rsub|S>=<frac|Var[S]|E[S]<rsup|2>>=\<mu\><rsup|2>
    Var[S]>

    <item>Esprances et variances

    <\equation*>
      X\<sim\>U(a,b)<htab|5mm>E[X]=<frac|a+b|2><htab|5mm>\<sigma\><rsub|X><rsup|2>=<frac|(a+b)<rsup|2>|12>
    </equation*>

    <\equation*>
      Y\<sim\>\<varepsilon\>(\<lambda\>)<htab|5mm>E[Y]=<frac|1|\<lambda\>><htab|5mm>\<sigma\><rsub|Y><rsup|2>=<frac|1|\<lambda\><rsup|2>>
    </equation*>

    <\equation*>
      \;
    </equation*>
  </itemize-minus>

  <section|Programmation dynamique>

  <subsection|Modlisation>

  <paragraph|Systme dynamique>

  <\itemize-minus>
    <item>tapes <with|mode|math|N>

    <item>tat <with|mode|math|x<rsub|k>>

    <item>Ensemble <with|mode|math|S<rsub|k>> des tats  l'tape
    <with|mode|math|k>

    <item>tat initial <with|mode|math|x<rsub|1>>

    <item>tat terminal <with|mode|math|x<rsub|N+1>>

    <item>Dcision <with|mode|math|u<rsub|k>>

    <item>Ensemble <with|mode|math|C<rsub|k>> des dcisions possibles 
    l'tape <with|mode|math|k>

    <item>Ensemble <with|mode|math|U<rsub|k>(x<rsub|k>)> des dcisions
    admissibles dans l'tat <with|mode|math|x<rsub|k>>  l'tape
    <with|mode|math|k>

    <item>fonction de transfert
  </itemize-minus>

  <paragraph|Fonction cot>

  <\itemize-minus>
    <item>fonction de cot <with|mode|math|g<rsub|k>(x<rsub|k>,u<rsub|k>,\<omega\><rsub|k>)>

    <item>cot terminal <with|mode|math|g<rsub|N+1>(x<rsub|N+1>)>

    <item>cots totaux: <with|mode|math|g<rsub|N+1>(x<rsub|N+1>)+<big|sum><rsup|N><rsub|k=1>g<rsub|k>(x<rsub|k>,u<rsub|k>,\<omega\><rsub|k>)>
  </itemize-minus>

  <subsection|Rsolution>

  <\equation*>
    J<rsub|k>(x<rsub|k>)=max<rsub|u<rsub|k>\<in\>U<rsub|k>(x<rsub|k>)><left|(>g<rsub|k>(x<rsub|k>,u<rsub|k>)<right|)>+J<rsub|N+1>(x<rsub|k+1>)
  </equation*>

  <with|mode|math|<tabular|<tformat|<cwith|1|7|1|5|cell-halign|c>|<cwith|1|7|1|5|cell-rborder|1px>|<cwith|1|7|5|5|cell-rborder|0>|<cwith|1|1|1|5|cell-bborder|1px>|<table|<row|<cell|x<rsub|k>>|<cell|J<rsub|k>(x<rsub|k>,0)>|<cell|J<rsub|k>(x<rsub|k>,1)>|<cell|J<rsub|k>(x<rsub|k>)>|<cell|\<mu\><rsup|\<ast\>><rsub|k>(x<rsub|k>)=u<rsup|\<ast\>><rsub|k>>>|<row|<cell|0>|<cell|0>|<cell|->|<cell|0>|<cell|0>>|<row|<cell|1>|<cell|0>|<cell|->|<cell|0>|<cell|0>>|<row|<cell|2>|<cell|0>|<cell|->|<cell|0>|<cell|0>>|<row|<cell|3>|<cell|0>|<cell|->|<cell|0>|<cell|0>>|<row|<cell|4>|<cell|0>|<cell|->|<cell|0>|<cell|0>>|<row|<cell|5>|<cell|0>|<cell|15>|<cell|15>|<cell|1>>>>>>

  Est le tableau de base pour la rsolution des problmes de programmation
  dynamique. La 1re colonne contient l'tat possible au moment k. Les
  colonnes suivantes contiennent le cot en fonction de la dcision prise ;
  l'avant dernire colonne contient le cot maximum que l'on peut obtenir en
  k ; la dernire colonne donne le nombre d'objets choisi pour avoir un cot
  maximum.

  <subsection|Algorithme de Wagner Whitin>

  Soient <with|mode|math|d<rsub|t>> la demande, <with|mode|math|K<rsub|t>>
  les cots fixes, <with|mode|math|c<rsub|t>> les cots unitaires de
  production et <with|mode|math|h<rsub|t>> ceux de stockage durant la priode
  <with|mode|math|t>.\ 

  <\itemize-minus>
    <item>calcul des <with|mode|math|c<rsub|i j>>, le cot engendr par une
    production  la priode <with|mode|math|i> de la quantit ncessaire 
    satisfaire la demande jusqu' la priode j:

    <\equation*>
      c<rsub|i j>=K<rsub|i>+c<rsub|i><big|sum><rsub|t=i><rsup|j>d<rsub|t>+<big|sum><rsub|t=i><rsup|j-1>h<rsub|t><big|sum><rsub|k=t+1><rsup|j>d<rsub|k>
    </equation*>

    <item>calcul du cot optimal pour les priodes <with|mode|math|i> 
    <with|mode|math|N> via les quation de rcurrence suivantes:

    <\eqnarray*>
      <tformat|<table|<row|<cell|J<rsub|i>>|<cell|=>|<cell|min<rsub|i\<leq\>j\<leq\>N><left|(>c<rsub|i
      j>+J<rsub|j+1><right|)> \ \ \ \ \ \ \ i=N,\<ldots\>,1<htab|5mm>>>|<row|<cell|J<rsub|N+1>>|<cell|=>|<cell|0>>>>
    </eqnarray*>

    Le cot optimal est donn par <with|mode|math|J<rsub|1>>
  </itemize-minus>

  <page-break>

  <\example>
    Soient les donnes et les <with|mode|math|c<rsub|i j>>

    <\equation*>
      <tabular*|<tformat|<cwith|1|5|1|1|cell-rborder|1px>|<cwith|1|1|1|5|cell-bborder|1px>|<table|<row|<cell|t>|<cell|d<rsub|t>>|<cell|K<rsub|t>>|<cell|c<rsub|t>>|<cell|h<rsub|t>>>|<row|<cell|1>|<cell|4>|<cell|40>|<cell|9>|<cell|3>>|<row|<cell|2>|<cell|12>|<cell|20>|<cell|7>|<cell|6>>|<row|<cell|3>|<cell|15>|<cell|30>|<cell|5>|<cell|4>>|<row|<cell|4>|<cell|8>|<cell|50>|<cell|4>|<cell|->>>>><htab|5mm><tabular*|<tformat|<cwith|1|1|1|5|cell-bborder|1px>|<cwith|1|5|1|1|cell-rborder|1px>|<table|<row|<cell|i
      \<backslash\>j>|<cell|1>|<cell|2>|<cell|3>|<cell|4>>|<row|<cell|1>|<cell|76>|<cell|220>|<cell|490>|<cell|666>>|<row|<cell|2>|<cell|->|<cell|104>|<cell|299>|<cell|435>>|<row|<cell|3>|<cell|->|<cell|->|<cell|105>|<cell|177>>|<row|<cell|4>|<cell|->|<cell|->|<cell|->|<cell|82>>>>>
    </equation*>

    Les tables optimales sont alors

    <\equation*>
      <tabular|<tformat|<cwith|1|2|1|2|cell-lsep|10px>|<cwith|1|2|1|2|cell-rsep|10px>|<cwith|1|2|1|2|cell-bsep|10px>|<cwith|1|2|1|2|cell-tsep|10px>|<table|<row|<cell|J<rsub|4>=82+0=82>|<cell|J<rsub|3>=min<choice|<tformat|<table|<row|<cell|105+82=187>>|<row|<cell|177+0=177>>>>>>>|<row|<cell|J<rsub|2>=min<choice|<tformat|<table|<row|<cell|104+177=281>>|<row|<cell|299+82=381>>|<row|<cell|435+0=435>>>>>>|<cell|J<rsub|1>=min<choice|<tformat|<table|<row|<cell|76+281=357>>|<row|<cell|220+177=397>>|<row|<cell|490+82=572>>|<row|<cell|666+0=666>>>>>>>>>>
    </equation*>

    On a alors

    <\equation*>
      <tabular|<tformat|<cwith|1|1|1|5|cell-bborder|1px>|<cwith|1|4|1|1|cell-rborder|1px>|<cwith|1|3|1|5|cell-halign|c>|<table|<row|<cell|i
      >|<cell|4>|<cell|3>|<cell|2>|<cell|1>>|<row|<cell|J<rsub|i>>|<cell|82>|<cell|177>|<cell|281>|<cell|357>>|<row|<cell|\<mu\><rsup|\<ast\>>(i)>|<cell|4>|<cell|4>|<cell|2>|<cell|1>>>>>
    </equation*>

    Et le plan optimal est

    <\eqnarray*>
      <tformat|<table|<row|<cell|x<rsub|1>>|<cell|=>|<cell|d<rsub|1>=4>>|<row|<cell|x<rsub|2>>|<cell|=>|<cell|d<rsub|2>=12>>|<row|<cell|x<rsub|3>>|<cell|=>|<cell|d<rsub|3>+d<rsub|4>=23>>|<row|<cell|x<rsub|4>>|<cell|=>|<cell|0>>>>
    </eqnarray*>
  </example>
</body>

<\initial>
  <\collection>
    <associate|page-show-hf|true>
    <associate|page-even|2cm>
    <associate|page-reduce-right|0mm>
    <associate|page-medium|paper>
    <associate|page-reduce-bot|0mm>
    <associate|page-reduce-left|0mm>
    <associate|par-first|0>
    <associate|page-type|a4>
    <associate|page-top|2cm>
    <associate|page-right|2cm>
    <associate|font-base-size|10>
    <associate|par-width|170.007mm>
    <associate|page-odd|2cm>
    <associate|page-bot|2cm>
    <associate|language|french>
    <associate|page-reduce-top|0mm>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|toc-20|<tuple|2|5>>
    <associate|toc-70|<tuple|3.3.6|13>>
    <associate|toc-60|<tuple|3.2.4|11>>
    <associate|toc-30|<tuple|2.3.1|6>>
    <associate|toc-80|<tuple|4.1|14>>
    <associate|toc-40|<tuple|4.|7>>
    <associate|toc-50|<tuple|2.4.7|9>>
    <associate|toc-10|<tuple|1.5.1|2>>
    <associate|toc-21|<tuple|2.1|5>>
    <associate|gly-1|<tuple|1|?>>
    <associate|toc-41|<tuple|2.|7>>
    <associate|toc-51|<tuple|2.4.8|10>>
    <associate|toc-61|<tuple|3.2.5|12>>
    <associate|toc-81|<tuple|4.2|14>>
    <associate|toc-71|<tuple|3.3.7|13>>
    <associate|toc-31|<tuple|2.3.1|6>>
    <associate|toc-11|<tuple|1.5.1|2>>
    <associate|toc-82|<tuple|4.3|14>>
    <associate|toc-62|<tuple|3.3|12>>
    <associate|toc-22|<tuple|2.2|5>>
    <associate|toc-12|<tuple|3.|3>>
    <associate|toc-32|<tuple|3.|6>>
    <associate|toc-42|<tuple|2.|8>>
    <associate|toc-52|<tuple|2.4.9|10>>
    <associate|toc-72|<tuple|3.3.8|13>>
    <associate|toc-83|<tuple|4.3.1|?>>
    <associate|toc-73|<tuple|3.3.9|13>>
    <associate|toc-63|<tuple|3.3.1|12>>
    <associate|toc-23|<tuple|2.2.1|5>>
    <associate|toc-13|<tuple|1.5.2|3>>
    <associate|toc-33|<tuple|2.3.2|6>>
    <associate|toc-43|<tuple|2.4|8>>
    <associate|toc-53|<tuple|2.4.10|10>>
    <associate|toc-14|<tuple|1.5.2|3>>
    <associate|toc-24|<tuple|2.2.1|5>>
    <associate|toc-74|<tuple|3.3.9|13>>
    <associate|toc-34|<tuple|2.3.2|6>>
    <associate|toc-44|<tuple|2.4.1|8>>
    <associate|toc-54|<tuple|3|10>>
    <associate|toc-64|<tuple|3.3.2|12>>
    <associate|toc-75|<tuple|3.3.10|13>>
    <associate|toc-65|<tuple|3.3.2|12>>
    <associate|toc-25|<tuple|2.2.1|5>>
    <associate|toc-15|<tuple|4.|3>>
    <associate|toc-35|<tuple|2.3.2|6>>
    <associate|toc-45|<tuple|2.4.2|8>>
    <associate|toc-55|<tuple|3.1|10>>
    <associate|toc-96|<tuple|3.1.78|?>>
    <associate|toc-76|<tuple|3.3.10|13>>
    <associate|toc-26|<tuple|2.2.2|5>>
    <associate|toc-16|<tuple|1.6|4>>
    <associate|toc-36|<tuple|3|7>>
    <associate|toc-46|<tuple|2.4.3|9>>
    <associate|toc-56|<tuple|3.2|10>>
    <associate|toc-66|<tuple|3.3.2|12>>
    <associate|toc-77|<tuple|4|14>>
    <associate|toc-57|<tuple|3.2.1|10>>
    <associate|toc-27|<tuple|2.2.2|5>>
    <associate|toc-17|<tuple|1.6.1|4>>
    <associate|toc-37|<tuple|4|7>>
    <associate|toc-47|<tuple|2.4.4|9>>
    <associate|toc-67|<tuple|3.3.3|12>>
    <associate|toc-38|<tuple|4|7>>
    <associate|toc-48|<tuple|2.4.5|9>>
    <associate|toc-58|<tuple|3.2.2|11>>
    <associate|toc-68|<tuple|3.3.4|12>>
    <associate|toc-28|<tuple|2.2.2|5>>
    <associate|toc-18|<tuple|1.6.2|4>>
    <associate|toc-78|<tuple|4.1|14>>
    <associate|toc-88|<tuple|3.1.62|?>>
    <associate|toc-69|<tuple|3.3.5|13>>
    <associate|toc-59|<tuple|3.2.3|11>>
    <associate|toc-79|<tuple|4.1|14>>
    <associate|toc-29|<tuple|2.3|6>>
    <associate|toc-19|<tuple|1.6.3|4>>
    <associate|toc-39|<tuple|4.|7>>
    <associate|toc-49|<tuple|2.4.6|9>>
    <associate|toc-240|<tuple|3.1.366|?>>
    <associate|toc-150|<tuple|3.1.186|?>>
    <associate|toc-120|<tuple|3.1.126|?>>
    <associate|toc-100|<tuple|3.1.86|?>>
    <associate|toc-151|<tuple|3.1.189|?>>
    <associate|toc-232|<tuple|3.1.350|?>>
    <associate|toc-102|<tuple|3.1.90|?>>
    <associate|toc-103|<tuple|3.1.93|?>>
    <associate|toc-244|<tuple|3.1.374|?>>
    <associate|toc-184|<tuple|3.1.254|?>>
    <associate|toc-144|<tuple|3.1.174|?>>
    <associate|toc-246|<tuple|3.1.378|?>>
    <associate|toc-216|<tuple|3.1.318|?>>
    <associate|toc-136|<tuple|3.1.158|?>>
    <associate|toc-247|<tuple|3.1.381|?>>
    <associate|toc-148|<tuple|3.1.182|?>>
    <associate|toc-1|<tuple|1|1>>
    <associate|toc-2|<tuple|1.1|1>>
    <associate|toc-3|<tuple|1.2|1>>
    <associate|toc-4|<tuple|1.3|1>>
    <associate|toc-5|<tuple|1.4|2>>
    <associate|toc-6|<tuple|1.4.1|2>>
    <associate|toc-7|<tuple|1.4.2|2>>
    <associate|toc-8|<tuple|1.5|2>>
    <associate|toc-9|<tuple|1.5|2>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|toc>
      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|1<space|2spc>Programmation
      linaire><value|toc-dots><pageref|toc-1><vspace|0.5fn>

      1.1<space|2spc>Formes d'un programme
      linaire<value|toc-dots><pageref|toc-2>

      1.2<space|2spc>Rgles de transformation<value|toc-dots><pageref|toc-3>

      1.3<space|2spc>Rgles de dualisation<value|toc-dots><pageref|toc-4>

      1.4<space|2spc>Tableaux<value|toc-dots><pageref|toc-5>

      <with|par-left|<quote|1.5fn>|1.4.1<space|2spc>Construction<value|toc-dots><pageref|toc-6>>

      <with|par-left|<quote|1.5fn>|1.4.2<space|2spc>Proprits<value|toc-dots><pageref|toc-7>>

      1.5<space|2spc>Algorithme du Simplexe<value|toc-dots><pageref|toc-8>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Rgle de
      Bland<value|toc-dots><pageref|toc-9>>

      <with|par-left|<quote|1.5fn>|1.5.1<space|2spc>Phase
      I<value|toc-dots><pageref|toc-10>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Primal<value|toc-dots><pageref|toc-11>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Dual<value|toc-dots><pageref|toc-12>>

      <with|par-left|<quote|1.5fn>|1.5.2<space|2spc>Phase
      II<value|toc-dots><pageref|toc-13>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Primal<value|toc-dots><pageref|toc-14>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Dual<value|toc-dots><pageref|toc-15>>

      1.6<space|2spc>Analyse de sensibilit<value|toc-dots><pageref|toc-16>

      <with|par-left|<quote|1.5fn>|1.6.1<space|2spc>Sensibilit du second
      membre<value|toc-dots><pageref|toc-17>>

      <with|par-left|<quote|1.5fn>|1.6.2<space|2spc>Sensibilit de la
      fonction objectif<value|toc-dots><pageref|toc-18>>

      <with|par-left|<quote|1.5fn>|1.6.3<space|2spc>Ajout de
      contrainte<value|toc-dots><pageref|toc-19>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|2<space|2spc>Thories
      des graphes><value|toc-dots><pageref|toc-20><vspace|0.5fn>

      2.1<space|2spc>Dfinitions<value|toc-dots><pageref|toc-21>

      2.2<space|2spc>Matrice d'adjacence et
      d'incidence<value|toc-dots><pageref|toc-22>

      <with|par-left|<quote|1.5fn>|2.2.1<space|2spc>Graphe simple non
      orient<value|toc-dots><pageref|toc-23>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Matrice d'adjacence
      sommets-sommets <with|mode|<quote|math>|B: n \<times\>
      n><value|toc-dots><pageref|toc-24>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Matrice d'incidence
      sommets-artes <with|mode|<quote|math>|A: n \<times\>
      m><value|toc-dots><pageref|toc-25>>

      <with|par-left|<quote|1.5fn>|2.2.2<space|2spc>Graphe simple
      orient<value|toc-dots><pageref|toc-26>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Matrice d'adjacence
      sommets-sommets <with|mode|<quote|math>|B: n \<times\>
      n><value|toc-dots><pageref|toc-27>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Matrice d'incidence
      sommets-artes <with|mode|<quote|math>|A: n \<times\>
      m><value|toc-dots><pageref|toc-28>>

      2.3<space|2spc>Algorithmes<value|toc-dots><pageref|toc-29>

      <with|par-left|<quote|1.5fn>|2.3.1<space|2spc>Problme de l'arbre
      recouvrant de poids minimum<value|toc-dots><pageref|toc-30>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Algorithme de
      Kruskal<value|toc-dots><pageref|toc-31>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Algorithme de
      Prim<value|toc-dots><pageref|toc-32>>

      <with|par-left|<quote|1.5fn>|2.3.2<space|2spc>Problmes de plus courts
      chemins<value|toc-dots><pageref|toc-33>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Principe d'optimalit
      de Bellman<value|toc-dots><pageref|toc-34>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Algorithme
      gnrique<value|toc-dots><pageref|toc-35>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Algorithme de
      Dijkstra<value|toc-dots><pageref|toc-36>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Graphes
      acycliques<value|toc-dots><pageref|toc-37>>

      <with|par-left|<quote|7.5fn>|font-size|<quote|0.84>|Algorithme du
      rang<value|toc-dots><pageref|toc-38>>

      <with|par-left|<quote|7.5fn>|font-size|<quote|0.84>|Tri
      topologique<value|toc-dots><pageref|toc-39>>

      <with|par-left|<quote|7.5fn>|font-size|<quote|0.84>|Plus courts chemins
      dans les rseaux sans circuit<value|toc-dots><pageref|toc-40>>

      <with|par-left|<quote|7.5fn>|font-size|<quote|0.84>|Application  la
      gestion de projet<value|toc-dots><pageref|toc-41>>

      <with|par-left|<quote|7.5fn>|font-size|<quote|0.84>|Algorithme du
      chemin critique<value|toc-dots><pageref|toc-42>>

      2.4<space|2spc>Problme du transbordement<value|toc-dots><pageref|toc-43>

      <with|par-left|<quote|1.5fn>|2.4.1<space|2spc>Dfinition<value|toc-dots><pageref|toc-44>>

      <with|par-left|<quote|1.5fn>|2.4.2<space|2spc>Algorithme<value|toc-dots><pageref|toc-45>>

      <with|par-left|<quote|1.5fn>|2.4.3<space|2spc>L'algorithme graphique du
      Simplexe dans les rseaux<value|toc-dots><pageref|toc-46>>

      <with|par-left|<quote|1.5fn>|2.4.4<space|2spc>Construction du problme
      auxiliaire et de sa solution initiale
      admissible<value|toc-dots><pageref|toc-47>>

      <with|par-left|<quote|1.5fn>|2.4.5<space|2spc>Calcul de la solution
      primale <with|mode|<quote|math>|x> associe 
      <with|mode|<quote|math>|T=(V,E<rsub|T>)><value|toc-dots><pageref|toc-48>>

      <with|par-left|<quote|1.5fn>|2.4.6<space|2spc>Calcul de la solution
      duale <with|mode|<quote|math>|y> associe 
      <with|mode|<quote|math>|T=(V, E<rsub|T>)><value|toc-dots><pageref|toc-49>>

      <with|par-left|<quote|1.5fn>|2.4.7<space|2spc>Recherche d'un arc
      entrant<value|toc-dots><pageref|toc-50>>

      <with|par-left|<quote|1.5fn>|2.4.8<space|2spc>Recherche d'un arc
      sortant<value|toc-dots><pageref|toc-51>>

      <with|par-left|<quote|1.5fn>|2.4.9<space|2spc>Mise  jour des
      solutions<value|toc-dots><pageref|toc-52>>

      <with|par-left|<quote|1.5fn>|2.4.10<space|2spc>Dgnrescence<value|toc-dots><pageref|toc-53>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|3<space|2spc>Chanes
      de Markov><value|toc-dots><pageref|toc-54><vspace|0.5fn>

      3.1<space|2spc>Dfinitions<value|toc-dots><pageref|toc-55>

      3.2<space|2spc>Chanes de Markov  temps
      discret<value|toc-dots><pageref|toc-56>

      <with|par-left|<quote|1.5fn>|3.2.1<space|2spc>Matrice de
      transition<value|toc-dots><pageref|toc-57>>

      <with|par-left|<quote|1.5fn>|3.2.2<space|2spc>Classification<value|toc-dots><pageref|toc-58>>

      <with|par-left|<quote|1.5fn>|3.2.3<space|2spc>tude des classes
      persistantes<value|toc-dots><pageref|toc-59>>

      <with|par-left|<quote|1.5fn>|3.2.4<space|2spc>tude des tats
      transitoires<value|toc-dots><pageref|toc-60>>

      <with|par-left|<quote|1.5fn>|3.2.5<space|2spc>Interprtation<value|toc-dots><pageref|toc-61>>

      3.3<space|2spc>Chanes de Markov  temps
      continu<value|toc-dots><pageref|toc-62>

      <with|par-left|<quote|1.5fn>|3.3.1<space|2spc>Probabilits et matrices
      de transition<value|toc-dots><pageref|toc-63>>

      <with|par-left|<quote|1.5fn>|3.3.2<space|2spc>Classification<value|toc-dots><pageref|toc-64>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Classe et
      tat<value|toc-dots><pageref|toc-65>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Chane<value|toc-dots><pageref|toc-66>>

      <with|par-left|<quote|1.5fn>|3.3.3<space|2spc>Structure<value|toc-dots><pageref|toc-67>>

      <with|par-left|<quote|1.5fn>|3.3.4<space|2spc>Loi
      exponentielle<value|toc-dots><pageref|toc-68>>

      <with|par-left|<quote|1.5fn>|3.3.5<space|2spc>Matrice
      gnratrice<value|toc-dots><pageref|toc-69>>

      <with|par-left|<quote|1.5fn>|3.3.6<space|2spc>Matrice de transition de
      la chane sous-jacente<value|toc-dots><pageref|toc-70>>

      <with|par-left|<quote|1.5fn>|3.3.7<space|2spc>quations de
      Kolmogorov<value|toc-dots><pageref|toc-71>>

      <with|par-left|<quote|1.5fn>|3.3.8<space|2spc>Distribution<value|toc-dots><pageref|toc-72>>

      <with|par-left|<quote|1.5fn>|3.3.9<space|2spc>Processus de naissance et
      de mort<value|toc-dots><pageref|toc-73>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Processus de
      Poisson<value|toc-dots><pageref|toc-74>>

      <with|par-left|<quote|1.5fn>|3.3.10<space|2spc>Files
      d'attentes<value|toc-dots><pageref|toc-75>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Ajouts<value|toc-dots><pageref|toc-76>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|4<space|2spc>Programmation
      dynamique><value|toc-dots><pageref|toc-77><vspace|0.5fn>

      4.1<space|2spc>Modlisation<value|toc-dots><pageref|toc-78>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Systme
      dynamique<value|toc-dots><pageref|toc-79>>

      <with|par-left|<quote|6fn>|font-size|<quote|0.84>|Fonction
      cot<value|toc-dots><pageref|toc-80>>

      4.2<space|2spc>Rsolution<value|toc-dots><pageref|toc-81>

      4.3<space|2spc>Algorithme de Wagner
      Whitin<value|toc-dots><pageref|toc-82>
    </associate>
  </collection>
</auxiliary>=