<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="/">
		<html>
			<body>
				<table border="1">
					<tbody>
						<tr>
							<th>Author</th>
							<th>Comic Book title</th>
						</tr>
						<xsl:apply-templates select=".//Person[../../..//Author/@ref = @id]">
							<xsl:sort order="ascending" select="./Lastname"/>
						</xsl:apply-templates>
					</tbody>
				</table>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="Person">
		<xsl:variable name="thePerson" select="@id"/>
		<tr>
			<td>
				<xsl:value-of select="./Lastname" />
			</td>
			<td>
				<ul>
					<xsl:apply-templates select="../..//ComicBook[Author/@ref = $thePerson]"/>
				</ul>
			</td>
		</tr>
	</xsl:template>
	<xsl:template match="ComicBook">
			<li>
			<xsl:value-of select="./Title"/>
			<xsl:apply-templates select="parent::Series"/>
			</li>
</xsl:template>
	<xsl:template match="Series">
		<xsl:text> [ in the series: </xsl:text>
			<xsl:value-of select="./SeriesTitle"/>
		<xsl:text>]</xsl:text>
	</xsl:template>
</xsl:stylesheet>
